/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.beatrix.integration.osgi;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.killbill.billing.beatrix.integration.osgi.TestOSGIBase;
import org.killbill.billing.beatrix.integration.osgi.util.ExternalBusTestEvent;
import org.killbill.billing.beatrix.integration.osgi.util.SetupBundleWithAssertion;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.notification.plugin.api.ExtBusEventType;
import org.killbill.billing.payment.plugin.api.PaymentPluginApi;
import org.killbill.billing.payment.plugin.api.PaymentTransactionInfoPlugin;
import org.killbill.bus.api.BusEvent;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestBasicOSGIWithTestBundle
extends TestOSGIBase {
    private static final String TEST_PLUGIN_NAME = "test";
    private static final String BUNDLE_TEST_RESOURCE = "killbill-osgi-bundles-test-beatrix";

    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        super.beforeClass();
        String killbillVersion = System.getProperty("killbill.version");
        SetupBundleWithAssertion setupTest = new SetupBundleWithAssertion(BUNDLE_TEST_RESOURCE, this.osgiConfig, killbillVersion);
        setupTest.setupJavaBundle();
    }

    @Test(groups={"slow"})
    public void testBundleTest() throws Exception {
        TestActivatorWithAssertion assertTor = new TestActivatorWithAssertion(this.dbi);
        assertTor.assertPluginInitialized();
        ExternalBusTestEvent event = new ExternalBusTestEvent();
        this.externalBus.post((BusEvent)event);
        assertTor.assertPluginReceivedEvent(event.getAccountId().toString());
        PaymentPluginApi paymentPluginApi = (PaymentPluginApi)this.getTestApi(this.paymentPluginApiOSGIServiceRegistration, TEST_PLUGIN_NAME);
        UUID paymentId = UUID.randomUUID();
        UUID transactionId = UUID.randomUUID();
        UUID paymentMethodId = UUID.randomUUID();
        BigDecimal paymentAmount = new BigDecimal("14.32");
        Currency currency = Currency.USD;
        PaymentTransactionInfoPlugin PaymentTransactionInfoPlugin2 = paymentPluginApi.purchasePayment(event.getAccountId(), paymentId, transactionId, paymentMethodId, paymentAmount, currency, (Iterable)ImmutableList.of(), this.callContext);
        Assert.assertEquals((Object)PaymentTransactionInfoPlugin2.getKbPaymentId(), (Object)paymentId);
        Assert.assertEquals((Object)PaymentTransactionInfoPlugin2.getKbTransactionPaymentId(), (Object)transactionId);
        Assert.assertEquals((int)PaymentTransactionInfoPlugin2.getAmount().compareTo(paymentAmount), (int)0);
        Assert.assertEquals((Object)PaymentTransactionInfoPlugin2.getCurrency(), (Object)currency);
        assertTor.assertPluginCreatedPayment(paymentId, paymentMethodId, paymentAmount);
    }

    @Test(groups={"slow"})
    public void testBundleTestWithRetries() throws Exception {
        TestActivatorWithAssertion assertTor = new TestActivatorWithAssertion(this.dbi);
        assertTor.assertPluginInitialized();
        ExternalBusTestEvent event = new ExternalBusTestEvent(ExtBusEventType.BLOCKING_STATE, "5", UUID.randomUUID());
        this.externalBus.post((BusEvent)event);
        assertTor.assertPluginReceivedEvent("error-1");
        this.clock.addDeltaFromReality(300000L);
        assertTor.assertPluginReceivedEvent("error-2");
        this.clock.addDeltaFromReality(600000L);
        assertTor.assertPluginReceivedEvent("error-3");
        this.clock.addDeltaFromReality(2700000L);
        assertTor.assertPluginReceivedEvent("error-4");
        this.clock.addDeltaFromReality(18000000L);
        assertTor.assertPluginReceivedEvent(event.getAccountId().toString());
    }

    private static interface AwaitCallback {
        public boolean isSuccess();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TestMapper
    implements ResultSetMapper<TestModel> {
        private TestMapper() {
        }

        public TestModel map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            Boolean isStarted = r.getBoolean("is_started");
            String externalKey = r.getString("external_key");
            UUID paymentId = r.getString("payment_id") != null ? UUID.fromString(r.getString("payment_id")) : null;
            UUID paymentMethodId = r.getString("payment_method_id") != null ? UUID.fromString(r.getString("payment_method_id")) : null;
            BigDecimal amount = r.getBigDecimal("payment_amount");
            return new TestModel(isStarted, externalKey, paymentId, paymentMethodId, amount);
        }
    }

    private static final class TestModel {
        private final Boolean isStarted;
        private final String accountExternalKey;
        private final UUID paymentId;
        private final UUID paymentMethodId;
        private final BigDecimal amount;

        private TestModel(Boolean started, String accountExternalKey, UUID paymentId, UUID paymentMethodId, BigDecimal amount) {
            this.isStarted = started;
            this.accountExternalKey = accountExternalKey;
            this.paymentId = paymentId;
            this.paymentMethodId = paymentMethodId;
            this.amount = amount;
        }

        public Boolean isStarted() {
            return this.isStarted;
        }

        public String getAccountExternalKey() {
            return this.accountExternalKey;
        }

        public UUID getPaymentId() {
            return this.paymentId;
        }

        public UUID getPaymentMethodId() {
            return this.paymentMethodId;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }
    }

    private static final class TestActivatorWithAssertion {
        private final IDBI dbi;

        public TestActivatorWithAssertion(IDBI dbi) {
            this.dbi = dbi;
        }

        public void assertPluginInitialized() {
            this.assertWithCallback(new AwaitCallback(){

                public boolean isSuccess() {
                    return TestActivatorWithAssertion.this.isPluginInitialized();
                }
            }, "Plugin did not complete initialization");
        }

        public void assertPluginReceivedEvent(final String expectedExternalKey) {
            this.assertWithCallback(new AwaitCallback(){

                public boolean isSuccess() {
                    return TestActivatorWithAssertion.this.isValidAccountExternalKey(expectedExternalKey);
                }
            }, "Plugin did not receive event");
        }

        public void assertPluginCreatedPayment(final UUID expectedPaymentId, final UUID expectedPaymentMethodId, final BigDecimal expectedAmount) {
            this.assertWithCallback(new AwaitCallback(){

                public boolean isSuccess() {
                    return TestActivatorWithAssertion.this.isValidPayment(expectedPaymentId, expectedPaymentMethodId, expectedAmount);
                }
            }, "Plugin did not create the payment");
        }

        private void assertWithCallback(final AwaitCallback callback, String error) {
            try {
                Awaitility.await().atMost(15L, TimeUnit.SECONDS).until((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return callback.isSuccess();
                    }
                });
            }
            catch (Exception e) {
                Assert.fail((String)error, (Throwable)e);
            }
        }

        private boolean isValidPayment(UUID expectedPaymentId, UUID expectedPaymentMethodId, BigDecimal expectedAmount) {
            TestModel test = this.getTestModelFirstRecord();
            return expectedPaymentId.equals(test.getPaymentId()) && expectedPaymentMethodId.equals(test.getPaymentMethodId()) && expectedAmount.compareTo(test.getAmount()) == 0;
        }

        private boolean isPluginInitialized() {
            TestModel test = this.getTestModelFirstRecord();
            return test.isStarted();
        }

        private boolean isValidAccountExternalKey(String expectedExternalKey) {
            TestModel test = this.getTestModelFirstRecord();
            return expectedExternalKey.equals(test.getAccountExternalKey());
        }

        private TestModel getTestModelFirstRecord() {
            return (TestModel)this.dbi.inTransaction((TransactionCallback)new TransactionCallback<TestModel>(){

                public TestModel inTransaction(Handle conn, TransactionStatus status) throws Exception {
                    Query q = conn.createQuery("SELECT is_started, external_key, payment_id, payment_method_id, payment_amount FROM test_bundle WHERE record_id = 1;");
                    return (TestModel)q.map((ResultSetMapper)new TestMapper()).first();
                }
            });
        }
    }
}

