/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.platform.test.glue;

import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.killbill.billing.lifecycle.DefaultLifecycle;
import org.killbill.billing.lifecycle.api.Lifecycle;
import org.killbill.billing.lifecycle.glue.BusModule;
import org.killbill.billing.osgi.api.OSGIConfigProperties;
import org.killbill.billing.osgi.api.PluginInfo;
import org.killbill.billing.osgi.glue.DefaultOSGIModule;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.platform.api.KillbillService;
import org.killbill.billing.platform.glue.KillBillPlatformModuleBase;
import org.killbill.billing.platform.glue.NotificationQueueModule;
import org.killbill.billing.platform.jndi.JNDIManager;
import org.killbill.billing.platform.test.PlatformDBTestingHelper;
import org.killbill.billing.util.nodes.KillbillNodesApi;
import org.killbill.billing.util.nodes.NodeCommand;
import org.killbill.billing.util.nodes.NodeInfo;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.skife.jdbi.v2.IDBI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestPlatformModule
extends KillBillPlatformModuleBase {
    private final boolean withOSGI;
    private final OSGIConfigProperties osgiConfigProperties;
    private final Set<? extends KillbillService> services;

    protected TestPlatformModule(KillbillConfigSource configSource, boolean withOSGI, @Nullable OSGIConfigProperties osgiConfigProperties, @Nullable Set<? extends KillbillService> services) {
        super(configSource);
        this.withOSGI = withOSGI;
        this.osgiConfigProperties = osgiConfigProperties;
        this.services = services;
    }

    protected void configure() {
        this.configureEmbeddedDB();
        this.configureLifecycle();
        this.configureNotificationQ();
        this.configureBus();
        if (this.withOSGI) {
            this.configureExternalBus();
            this.configureOSGI();
        }
        this.configureJNDI();
        this.configureKillbillNodesApi();
    }

    protected void configureEmbeddedDB() {
        PlatformDBTestingHelper platformDBTestingHelper = PlatformDBTestingHelper.get();
        this.configureEmbeddedDB(platformDBTestingHelper);
    }

    protected void configureEmbeddedDB(PlatformDBTestingHelper platformDBTestingHelper) {
        EmbeddedDB instance = platformDBTestingHelper.getInstance();
        this.bind(EmbeddedDB.class).toInstance((Object)instance);
        try {
            this.bind(DataSource.class).toInstance((Object)platformDBTestingHelper.getDataSource());
            this.bind(IDBI.class).toInstance((Object)platformDBTestingHelper.getDBI());
            this.bind(IDBI.class).annotatedWith((Annotation)Names.named((String)"Queue")).toInstance((Object)platformDBTestingHelper.getDBI());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void configureLifecycle() {
        if (this.services != null) {
            this.bind(Lifecycle.class).toInstance((Object)new DefaultLifecycle(this.services));
        } else {
            this.bind(Lifecycle.class).to(DefaultLifecycle.class).asEagerSingleton();
        }
    }

    protected void configureBus() {
        this.install((Module)new BusModule(BusModule.BusType.PERSISTENT, false, this.configSource));
    }

    protected void configureExternalBus() {
        this.install((Module)new BusModule(BusModule.BusType.PERSISTENT, true, this.configSource));
    }

    protected void configureNotificationQ() {
        this.install((Module)new NotificationQueueModule(this.configSource));
    }

    protected void configureOSGI() {
        this.install((Module)new DefaultOSGIModule(this.configSource, this.osgiConfigProperties));
    }

    protected void configureJNDI() {
        this.bind(JNDIManager.class).asEagerSingleton();
    }

    protected void configureKillbillNodesApi() {
        KillbillNodesApi dummyInstance = new KillbillNodesApi(){

            public Iterable<NodeInfo> getNodesInfo() {
                throw new UnsupportedOperationException("Not implemented");
            }

            public void triggerNodeCommand(NodeCommand nodeCommandfinal, boolean localNodeOnly) {
                throw new UnsupportedOperationException("Not implemented");
            }

            public void notifyPluginChanged(PluginInfo pluginInfo) {
                throw new UnsupportedOperationException("Not implemented");
            }
        };
        this.bind(KillbillNodesApi.class).toInstance((Object)dummyInstance);
    }
}

