/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.platform.test;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.sql.DataSource;
import org.killbill.billing.platform.jndi.ReferenceableDataSourceSpy;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.killbill.commons.embeddeddb.h2.H2EmbeddedDB;
import org.killbill.commons.embeddeddb.mysql.MySQLEmbeddedDB;
import org.killbill.commons.embeddeddb.mysql.MySQLStandaloneDB;
import org.killbill.commons.embeddeddb.postgresql.PostgreSQLEmbeddedDB;
import org.killbill.commons.embeddeddb.postgresql.PostgreSQLStandaloneDB;
import org.killbill.commons.jdbi.guice.DBIProvider;
import org.skife.jdbi.v2.IDBI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformDBTestingHelper {
    private static final Logger log = LoggerFactory.getLogger(PlatformDBTestingHelper.class);
    private static final String TEST_DATA_SOURCE_ID = "test";
    private static final String TEST_DB_PROPERTY_PREFIX = "org.killbill.billing.dbi.test.";
    protected EmbeddedDB instance;
    private static PlatformDBTestingHelper dbTestingHelper = null;

    public static synchronized PlatformDBTestingHelper get() {
        if (dbTestingHelper == null) {
            dbTestingHelper = new PlatformDBTestingHelper();
        }
        return dbTestingHelper;
    }

    protected PlatformDBTestingHelper() {
        if ("true".equals(System.getProperty("org.killbill.billing.dbi.test.h2"))) {
            log.info("Using h2 as the embedded database");
            this.instance = new H2EmbeddedDB();
        } else if ("true".equals(System.getProperty("org.killbill.billing.dbi.test.postgresql"))) {
            if (this.isUsingLocalInstance()) {
                log.info("Using PostgreSQL local database");
                String databaseName = System.getProperty("org.killbill.billing.dbi.test.localDb.database", "killbill");
                String username = System.getProperty("org.killbill.billing.dbi.test.localDb.username", "postgres");
                String password = System.getProperty("org.killbill.billing.dbi.test.localDb.password", "postgres");
                this.instance = new PostgreSQLStandaloneDB(databaseName, username, password);
            } else {
                log.info("Using PostgreSQL as the embedded database");
                this.instance = new PostgreSQLEmbeddedDB();
            }
        } else if (this.isUsingLocalInstance()) {
            log.info("Using MySQL local database");
            String databaseName = System.getProperty("org.killbill.billing.dbi.test.localDb.database", "killbill");
            String username = System.getProperty("org.killbill.billing.dbi.test.localDb.username", "root");
            String password = System.getProperty("org.killbill.billing.dbi.test.localDb.password", "root");
            this.instance = new MySQLStandaloneDB(databaseName, username, password);
        } else {
            log.info("Using MySQL as the embedded database");
            this.instance = new MySQLEmbeddedDB();
        }
    }

    public EmbeddedDB getInstance() {
        return this.instance;
    }

    public synchronized IDBI getDBI() throws IOException {
        DataSource dataSource = this.getDataSource();
        return new DBIProvider(null, dataSource, null).get();
    }

    public DataSource getDataSource() throws IOException {
        DataSource realDataSource = this.instance.getDataSource();
        return new ReferenceableDataSourceSpy(realDataSource, TEST_DATA_SOURCE_ID);
    }

    public synchronized void start() throws IOException {
        this.instance.initialize();
        this.instance.start();
        if (this.isUsingLocalInstance()) {
            return;
        }
        this.executeEngineSpecificScripts();
        this.executePostStartupScripts();
        this.instance.refreshTableNames();
    }

    protected synchronized void executePostStartupScripts() throws IOException {
        String resourcesBase = "org/killbill/billing/beatrix";
        this.executePostStartupScripts("org/killbill/billing/beatrix");
    }

    protected void executePostStartupScripts(String resourcesBase) throws IOException {
        try {
            String databaseSpecificDDL = this.streamToString(Resources.getResource((String)(resourcesBase + "/" + "ddl-" + this.instance.getDBEngine().name().toLowerCase() + ".sql")).openStream());
            this.instance.executeScript(databaseSpecificDDL);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        String ddl = this.streamToString(Resources.getResource((String)(resourcesBase + "/ddl.sql")).openStream());
        this.instance.executeScript(ddl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void executeEngineSpecificScripts() throws IOException {
        switch (this.instance.getDBEngine()) {
            case POSTGRESQL: {
                int port = URI.create(this.instance.getJdbcConnectionString().substring(5)).getPort();
                PostgreSQLStandaloneDB postgreSQLDBConnection = new PostgreSQLStandaloneDB(this.instance.getDatabaseName(), "postgres", "postgres", "jdbc:postgresql://localhost:" + port + "/postgres");
                postgreSQLDBConnection.initialize();
                postgreSQLDBConnection.start();
                try {
                    postgreSQLDBConnection.executeScript("alter role " + this.instance.getUsername() + " with superuser;");
                    break;
                }
                finally {
                    postgreSQLDBConnection.stop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String streamToString(InputStream inputStream) throws IOException {
        try {
            String string = new String(ByteStreams.toByteArray((InputStream)inputStream), Charsets.UTF_8);
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    private boolean isUsingLocalInstance() {
        return System.getProperty("org.killbill.billing.dbi.test.useLocalDb") != null;
    }
}

