/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.platform.test;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.sql.DataSource;
import org.killbill.billing.platform.jndi.ReferenceableDataSourceSpy;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.killbill.commons.embeddeddb.h2.H2EmbeddedDB;
import org.killbill.commons.embeddeddb.mysql.MySQLEmbeddedDB;
import org.killbill.commons.embeddeddb.mysql.MySQLStandaloneDB;
import org.killbill.commons.jdbi.guice.DBIProvider;
import org.skife.jdbi.v2.IDBI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformDBTestingHelper {
    private static final Logger log = LoggerFactory.getLogger(PlatformDBTestingHelper.class);
    private static final String TEST_DATA_SOURCE_ID = "test";
    protected EmbeddedDB instance;
    private static PlatformDBTestingHelper dbTestingHelper = null;

    public static synchronized PlatformDBTestingHelper get() {
        if (dbTestingHelper == null) {
            dbTestingHelper = new PlatformDBTestingHelper();
        }
        return dbTestingHelper;
    }

    protected PlatformDBTestingHelper() {
        if ("true".equals(System.getProperty("org.killbill.billing.dbi.test.h2"))) {
            log.info("Using h2 as the embedded database");
            this.instance = new H2EmbeddedDB();
        } else if (this.isUsingLocalInstance()) {
            log.info("Using MySQL local database");
            String databaseName = System.getProperty("org.killbill.billing.dbi.test.localDb.database", "killbill");
            String username = System.getProperty("org.killbill.billing.dbi.test.localDb.password", "root");
            String password = System.getProperty("org.killbill.billing.dbi.test.localDb.username", "root");
            this.instance = new MySQLStandaloneDB(databaseName, username, password);
        } else {
            log.info("Using MySQL as the embedded database");
            this.instance = new MySQLEmbeddedDB();
        }
    }

    public EmbeddedDB getInstance() {
        return this.instance;
    }

    public synchronized IDBI getDBI() throws IOException {
        DataSource dataSource = this.getDataSource();
        return new DBIProvider(null, dataSource, null).get();
    }

    public DataSource getDataSource() throws IOException {
        DataSource realDataSource = this.instance.getDataSource();
        return new ReferenceableDataSourceSpy(realDataSource, TEST_DATA_SOURCE_ID);
    }

    public synchronized void start() throws IOException {
        this.instance.initialize();
        this.instance.start();
        if (this.isUsingLocalInstance()) {
            return;
        }
        this.executePostStartupScripts();
        this.instance.refreshTableNames();
    }

    protected synchronized void executePostStartupScripts() throws IOException {
        String ddl = this.streamToString(Resources.getResource((String)"org/killbill/billing/beatrix/ddl.sql").openStream());
        this.instance.executeScript(ddl);
    }

    protected String streamToString(final InputStream inputStream) throws IOException {
        InputSupplier<InputStream> inputSupplier = new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                return inputStream;
            }
        };
        return CharStreams.toString((InputSupplier)CharStreams.newReaderSupplier((InputSupplier)inputSupplier, (Charset)Charsets.UTF_8));
    }

    private boolean isUsingLocalInstance() {
        return System.getProperty("org.killbill.billing.dbi.test.useLocalDb") != null;
    }
}

