/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.beatrix.integration.osgi.glue;

import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.killbill.billing.currency.plugin.api.CurrencyPluginApi;
import org.killbill.billing.invoice.plugin.api.InvoicePluginApi;
import org.killbill.billing.osgi.api.OSGIConfigProperties;
import org.killbill.billing.osgi.api.OSGIServiceDescriptor;
import org.killbill.billing.osgi.api.OSGIServiceRegistration;
import org.killbill.billing.payment.plugin.api.PaymentPluginApi;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.platform.glue.KillBillModule;
import org.killbill.billing.platform.test.config.TestKillbillConfigSource;
import org.killbill.billing.platform.test.glue.TestPlatformModuleWithEmbeddedDB;
import org.killbill.billing.routing.plugin.api.PaymentRoutingPluginApi;
import org.killbill.clock.Clock;
import org.killbill.clock.ClockMock;

public class TestIntegrationModule
extends KillBillModule {
    public TestIntegrationModule(KillbillConfigSource configSource) {
        super(configSource);
    }

    protected void configure() {
        this.install((Module)new TestPlatformModuleWithEmbeddedDB(this.configSource, true, (OSGIConfigProperties)((TestKillbillConfigSource)this.configSource)));
        this.bind(Clock.class).to(ClockMock.class).asEagerSingleton();
        this.bind((TypeLiteral)new TypeLiteral<OSGIServiceRegistration<PaymentPluginApi>>(){}).toInstance(new TestPlatformPaymentProviderPluginRegistry<PaymentPluginApi>(PaymentPluginApi.class));
        this.bind((TypeLiteral)new TypeLiteral<OSGIServiceRegistration<CurrencyPluginApi>>(){}).toInstance(new TestPlatformPaymentProviderPluginRegistry<CurrencyPluginApi>(CurrencyPluginApi.class));
        this.bind((TypeLiteral)new TypeLiteral<OSGIServiceRegistration<InvoicePluginApi>>(){}).toInstance(new TestPlatformPaymentProviderPluginRegistry<InvoicePluginApi>(InvoicePluginApi.class));
        this.bind((TypeLiteral)new TypeLiteral<OSGIServiceRegistration<PaymentRoutingPluginApi>>(){}).toInstance(new TestPlatformPaymentProviderPluginRegistry<PaymentRoutingPluginApi>(PaymentRoutingPluginApi.class));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TestPlatformPaymentProviderPluginRegistry<T>
    implements OSGIServiceRegistration<T> {
        private final Map<String, T> pluginsByName = new ConcurrentHashMap<String, T>();
        private final Class<T> serviceType;

        public TestPlatformPaymentProviderPluginRegistry(Class<T> serviceType) {
            this.serviceType = serviceType;
        }

        public void registerService(OSGIServiceDescriptor desc, T service) {
            this.pluginsByName.put(desc.getRegistrationName(), service);
        }

        public void unregisterService(String serviceName) {
            this.pluginsByName.remove(serviceName);
        }

        public T getServiceForName(String name) {
            return this.pluginsByName.get(name);
        }

        public Set<String> getAllServices() {
            return this.pluginsByName.keySet();
        }

        public Class<T> getServiceType() {
            return this.serviceType;
        }
    }
}

