/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.beatrix.integration.osgi;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.killbill.billing.beatrix.integration.osgi.TestOSGIBase;
import org.killbill.billing.beatrix.integration.osgi.util.SetupBundleWithAssertion;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.payment.api.PaymentMethodPlugin;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.payment.plugin.api.PaymentMethodInfoPlugin;
import org.killbill.billing.payment.plugin.api.PaymentPluginApi;
import org.killbill.billing.payment.plugin.api.PaymentPluginStatus;
import org.killbill.billing.payment.plugin.api.PaymentTransactionInfoPlugin;
import org.killbill.billing.util.callcontext.TenantContext;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestJrubyPaymentPlugin
extends TestOSGIBase {
    private static final String BUNDLE_TEST_RESOURCE_PREFIX = "killbill-payment-test";
    private static final String BUNDLE_TEST_RESOURCE = "killbill-payment-test.tar.gz";

    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        super.beforeClass();
        String killbillVersion = System.getProperty("killbill.version");
        SetupBundleWithAssertion setupTest = new SetupBundleWithAssertion(BUNDLE_TEST_RESOURCE, this.osgiConfig, killbillVersion);
        setupTest.setupJrubyBundle();
    }

    @Test(groups={"slow"})
    public void testProcessPayment() throws Exception {
        PaymentPluginApi api = (PaymentPluginApi)this.getTestApi(this.paymentPluginApiOSGIServiceRegistration, BUNDLE_TEST_RESOURCE_PREFIX);
        DateTime beforeCall = new DateTime().toDateTime(DateTimeZone.UTC).minusSeconds(1);
        PaymentTransactionInfoPlugin res = api.purchasePayment(UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), BigDecimal.TEN, Currency.USD, (Iterable)ImmutableList.of(), this.callContext);
        DateTime afterCall = new DateTime().toDateTime(DateTimeZone.UTC).plusSeconds(1);
        Assert.assertTrue((res.getAmount().compareTo(BigDecimal.TEN) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((res.getCreatedDate().compareTo((ReadableInstant)beforeCall) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((res.getCreatedDate().compareTo((ReadableInstant)afterCall) <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((res.getEffectiveDate().compareTo((ReadableInstant)beforeCall) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((res.getEffectiveDate().compareTo((ReadableInstant)afterCall) <= 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)res.getGatewayError(), (String)"gateway_error");
        Assert.assertEquals((String)res.getGatewayErrorCode(), (String)"gateway_error_code");
        Assert.assertEquals((Object)res.getStatus(), (Object)PaymentPluginStatus.PROCESSED);
    }

    @Test(groups={"slow"})
    public void testGetPaymentInfo() throws Exception {
        PaymentPluginApi api = (PaymentPluginApi)this.getTestApi(this.paymentPluginApiOSGIServiceRegistration, BUNDLE_TEST_RESOURCE_PREFIX);
        DateTime beforeCall = new DateTime().toDateTime(DateTimeZone.UTC).minusSeconds(1);
        PaymentTransactionInfoPlugin res = (PaymentTransactionInfoPlugin)api.getPaymentInfo(UUID.randomUUID(), UUID.randomUUID(), (Iterable)ImmutableList.of(), (TenantContext)this.callContext).get(0);
        DateTime afterCall = new DateTime().toDateTime(DateTimeZone.UTC).plusSeconds(1);
        Assert.assertTrue((res.getAmount().compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((res.getCreatedDate().compareTo((ReadableInstant)beforeCall) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((res.getCreatedDate().compareTo((ReadableInstant)afterCall) <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((res.getEffectiveDate().compareTo((ReadableInstant)beforeCall) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((res.getEffectiveDate().compareTo((ReadableInstant)afterCall) <= 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)res.getGatewayError(), (String)"gateway_error");
        Assert.assertEquals((String)res.getGatewayErrorCode(), (String)"gateway_error_code");
        Assert.assertEquals((Object)res.getStatus(), (Object)PaymentPluginStatus.PROCESSED);
    }

    @Test(groups={"slow"})
    public void testProcessRefund() throws Exception {
        PaymentPluginApi api = (PaymentPluginApi)this.getTestApi(this.paymentPluginApiOSGIServiceRegistration, BUNDLE_TEST_RESOURCE_PREFIX);
        DateTime beforeCall = new DateTime().toDateTime(DateTimeZone.UTC).minusSeconds(1);
        PaymentTransactionInfoPlugin res = api.refundPayment(UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), BigDecimal.TEN, Currency.USD, (Iterable)ImmutableList.of(), this.callContext);
        DateTime afterCall = new DateTime().toDateTime(DateTimeZone.UTC).plusSeconds(1);
        Assert.assertTrue((res.getAmount().compareTo(BigDecimal.TEN) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((res.getCreatedDate().compareTo((ReadableInstant)beforeCall) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((res.getCreatedDate().compareTo((ReadableInstant)afterCall) <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((res.getEffectiveDate().compareTo((ReadableInstant)beforeCall) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((res.getEffectiveDate().compareTo((ReadableInstant)afterCall) <= 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)res.getGatewayError(), (String)"gateway_error");
        Assert.assertEquals((String)res.getGatewayErrorCode(), (String)"gateway_error_code");
        Assert.assertEquals((Object)res.getStatus(), (Object)PaymentPluginStatus.PROCESSED);
    }

    @Test(groups={"slow"})
    public void testAddPaymentMethod() throws Exception {
        PaymentPluginApi api = (PaymentPluginApi)this.getTestApi(this.paymentPluginApiOSGIServiceRegistration, BUNDLE_TEST_RESOURCE_PREFIX);
        PaymentMethodPlugin paymentMethodPlugin = (PaymentMethodPlugin)Mockito.mock(PaymentMethodPlugin.class);
        Mockito.when((Object)paymentMethodPlugin.getExternalPaymentMethodId()).thenReturn((Object)UUID.randomUUID().toString());
        api.addPaymentMethod(UUID.randomUUID(), UUID.randomUUID(), paymentMethodPlugin, true, (Iterable)ImmutableList.of(), this.callContext);
    }

    @Test(groups={"slow"})
    public void testDeletePaymentMethod() throws Exception {
        PaymentPluginApi api = (PaymentPluginApi)this.getTestApi(this.paymentPluginApiOSGIServiceRegistration, BUNDLE_TEST_RESOURCE_PREFIX);
        api.deletePaymentMethod(UUID.randomUUID(), UUID.randomUUID(), (Iterable)ImmutableList.of(), this.callContext);
    }

    @Test(groups={"slow"})
    public void testGetPaymentMethodDetail() throws Exception {
        PaymentPluginApi api = (PaymentPluginApi)this.getTestApi(this.paymentPluginApiOSGIServiceRegistration, BUNDLE_TEST_RESOURCE_PREFIX);
        PaymentMethodPlugin res = api.getPaymentMethodDetail(UUID.randomUUID(), UUID.randomUUID(), (Iterable)ImmutableList.of(), (TenantContext)this.callContext);
        Assert.assertEquals((String)res.getExternalPaymentMethodId(), (String)"external_payment_method_id");
        Assert.assertTrue((boolean)res.isDefaultPaymentMethod());
        Assert.assertEquals((int)res.getProperties().size(), (int)2);
        Assert.assertEquals((String)((PluginProperty)res.getProperties().get(0)).getKey(), (String)"key1");
        Assert.assertEquals((Object)((PluginProperty)res.getProperties().get(0)).getValue(), (Object)"value1");
        Assert.assertEquals((String)((PluginProperty)res.getProperties().get(1)).getKey(), (String)"key2");
        Assert.assertEquals((Object)((PluginProperty)res.getProperties().get(1)).getValue(), (Object)"value2");
    }

    @Test(groups={"slow"})
    public void testSetDefaultPaymentMethod() throws Exception {
        PaymentPluginApi api = (PaymentPluginApi)this.getTestApi(this.paymentPluginApiOSGIServiceRegistration, BUNDLE_TEST_RESOURCE_PREFIX);
        api.setDefaultPaymentMethod(UUID.randomUUID(), UUID.randomUUID(), (Iterable)ImmutableList.of(), this.callContext);
    }

    @Test(groups={"slow"})
    public void testGetPaymentMethods() throws Exception {
        PaymentPluginApi api = (PaymentPluginApi)this.getTestApi(this.paymentPluginApiOSGIServiceRegistration, BUNDLE_TEST_RESOURCE_PREFIX);
        UUID kbAccountId = UUID.randomUUID();
        List res = api.getPaymentMethods(kbAccountId, true, (Iterable)ImmutableList.of(), this.callContext);
        Assert.assertEquals((int)res.size(), (int)1);
        PaymentMethodInfoPlugin res0 = (PaymentMethodInfoPlugin)res.get(0);
        Assert.assertTrue((boolean)res0.isDefault());
        Assert.assertEquals((String)res0.getExternalPaymentMethodId(), (String)"external_payment_method_id");
        Assert.assertEquals((Object)res0.getAccountId(), (Object)kbAccountId);
        Assert.assertEquals((Object)res0.getPaymentMethodId(), (Object)kbAccountId);
    }
}

