/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.beatrix.integration.osgi;

import java.math.BigDecimal;
import java.util.Set;
import org.joda.time.DateTime;
import org.killbill.billing.beatrix.integration.osgi.TestOSGIBase;
import org.killbill.billing.beatrix.integration.osgi.util.SetupBundleWithAssertion;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.currency.api.Rate;
import org.killbill.billing.currency.plugin.api.CurrencyPluginApi;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestJrubyCurrencyPlugin
extends TestOSGIBase {
    private static final String BUNDLE_TEST_RESOURCE_PREFIX = "killbill-currency-plugin-test";
    private static final String BUNDLE_TEST_RESOURCE = "killbill-currency-plugin-test.tar.gz";

    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        super.beforeClass();
        String killbillVersion = System.getProperty("killbill.version");
        SetupBundleWithAssertion setupTest = new SetupBundleWithAssertion(BUNDLE_TEST_RESOURCE, this.osgiConfig, killbillVersion);
        setupTest.setupJrubyBundle();
    }

    @Test(groups={"slow"})
    public void testCurrencyApis() throws Exception {
        CurrencyPluginApi api = (CurrencyPluginApi)this.getTestApi(this.currencyPluginApiOSGIServiceRegistration, BUNDLE_TEST_RESOURCE_PREFIX);
        Set currencies = api.getBaseCurrencies();
        Assert.assertEquals((int)currencies.size(), (int)1);
        Assert.assertEquals(currencies.iterator().next(), (Object)Currency.USD);
        DateTime res = api.getLatestConversionDate(Currency.USD);
        Assert.assertNotNull((Object)res);
        Set rates = api.getCurrentRates(Currency.USD);
        Assert.assertEquals((int)rates.size(), (int)1);
        Rate theRate = (Rate)rates.iterator().next();
        Assert.assertEquals((Object)theRate.getBaseCurrency(), (Object)Currency.USD);
        Assert.assertEquals((Object)theRate.getCurrency(), (Object)Currency.BRL);
        Assert.assertTrue((theRate.getValue().compareTo(new BigDecimal("12.3")) == 0 ? 1 : 0) != 0);
    }
}

