/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.platform.test.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.killbill.billing.platform.config.DefaultKillbillConfigSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestKillbillConfigSource
extends DefaultKillbillConfigSource {
    private final String jdbcConnectionString;
    private final String jdbcUsername;
    private final String jdbcPassword;
    private final Map<String, String> extraDefaults;

    public TestKillbillConfigSource() {
        this(null, null, null);
    }

    public TestKillbillConfigSource(@Nullable String jdbcConnectionString, @Nullable String jdbcUsername, @Nullable String jdbcPassword) {
        this.jdbcConnectionString = jdbcConnectionString;
        this.jdbcUsername = jdbcUsername;
        this.jdbcPassword = jdbcPassword;
        this.extraDefaults = ImmutableMap.of();
    }

    public TestKillbillConfigSource(String file) throws URISyntaxException, IOException {
        this(file, null, null, null, (Map<String, String>)ImmutableMap.of());
    }

    public TestKillbillConfigSource(String file, @Nullable String jdbcConnectionString, @Nullable String jdbcUsername, @Nullable String jdbcPassword) throws URISyntaxException, IOException {
        this(file, jdbcConnectionString, jdbcUsername, jdbcPassword, (Map<String, String>)ImmutableMap.of());
    }

    public TestKillbillConfigSource(String file, @Nullable String jdbcConnectionString, @Nullable String jdbcUsername, @Nullable String jdbcPassword, Map<String, String> extraDefaults) throws URISyntaxException, IOException {
        super(file);
        this.jdbcConnectionString = jdbcConnectionString;
        this.jdbcUsername = jdbcUsername;
        this.jdbcPassword = jdbcPassword;
        this.extraDefaults = extraDefaults;
        this.populateDefaultProperties();
    }

    protected Properties getDefaultProperties() {
        Properties properties = super.getDefaultProperties();
        if (this.jdbcConnectionString != null) {
            properties.put("org.killbill.dao.url", this.jdbcConnectionString);
            properties.put("org.killbill.billing.osgi.dao.url", this.jdbcConnectionString);
        }
        if (this.jdbcUsername != null) {
            properties.put("org.killbill.dao.user", this.jdbcUsername);
            properties.put("org.killbill.billing.osgi.dao.user", this.jdbcUsername);
        }
        if (this.jdbcPassword != null) {
            properties.put("org.killbill.dao.password", this.jdbcPassword);
            properties.put("org.killbill.billing.osgi.dao.password", this.jdbcPassword);
        }
        properties.put("org.killbill.notificationq.main.sleep", "100");
        properties.put("org.killbill.notificationq.main.nbThreads", "1");
        properties.put("org.killbill.notificationq.main.prefetch", "1");
        properties.put("org.killbill.notificationq.main.claimed", "1");
        properties.put("org.killbill.notificationq.main.useInFlightQ", "false");
        properties.put("org.killbill.persistent.bus.main.sleep", "100");
        properties.put("org.killbill.persistent.bus.main.nbThreads", "1");
        properties.put("org.killbill.persistent.bus.main.prefetch", "1");
        properties.put("org.killbill.persistent.bus.main.claimed", "1");
        properties.put("org.killbill.persistent.bus.main.useInFlightQ", "true");
        properties.put("org.killbill.persistent.bus.external.sleep", "100");
        properties.put("org.killbill.persistent.bus.external.nbThreads", "1");
        properties.put("org.killbill.persistent.bus.external.prefetch", "1");
        properties.put("org.killbill.persistent.bus.external.claimed", "1");
        properties.put("org.killbill.persistent.bus.external.useInFlightQ", "true");
        properties.put("org.killbill.osgi.root.dir", Files.createTempDir().getAbsolutePath());
        properties.put("org.killbill.osgi.bundle.install.dir", Files.createTempDir().getAbsolutePath());
        if (this.extraDefaults != null) {
            for (String key : this.extraDefaults.keySet()) {
                properties.put(key, this.extraDefaults.get(key));
            }
        }
        return properties;
    }

    protected Properties getDefaultSystemProperties() {
        Properties properties = super.getDefaultSystemProperties();
        properties.put("net.sf.ehcache.skipUpdateCheck", "true");
        properties.put("org.slf4j.simpleLogger.showDateTime", "true");
        return properties;
    }
}

