/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.test;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.osgi.api.PaymentPluginApiWithTestControl;
import org.killbill.billing.payment.api.PaymentMethodPlugin;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.payment.api.TransactionType;
import org.killbill.billing.payment.plugin.api.GatewayNotification;
import org.killbill.billing.payment.plugin.api.HostedPaymentPageFormDescriptor;
import org.killbill.billing.payment.plugin.api.PaymentMethodInfoPlugin;
import org.killbill.billing.payment.plugin.api.PaymentPluginApiException;
import org.killbill.billing.payment.plugin.api.PaymentPluginStatus;
import org.killbill.billing.payment.plugin.api.PaymentTransactionInfoPlugin;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPaymentPluginApi
implements PaymentPluginApiWithTestControl {
    private PaymentPluginApiException paymentPluginApiExceptionOnNextCalls;
    private RuntimeException runtimeExceptionOnNextCalls;

    public TestPaymentPluginApi() {
        this.resetToNormalBehavior();
    }

    public PaymentTransactionInfoPlugin authorizePayment(UUID kbAccountId, UUID kbPaymentId, UUID kbTransactionId, UUID kbPaymentMethodId, BigDecimal amount, Currency currency, Iterable<PluginProperty> properties, CallContext context) throws PaymentPluginApiException {
        return this.getPaymentTransactionInfoPluginResult(kbPaymentId, kbTransactionId, TransactionType.AUTHORIZE, amount, currency);
    }

    public PaymentTransactionInfoPlugin capturePayment(UUID kbAccountId, UUID kbPaymentId, UUID kbTransactionId, UUID kbPaymentMethodId, BigDecimal amount, Currency currency, Iterable<PluginProperty> properties, CallContext context) throws PaymentPluginApiException {
        return this.getPaymentTransactionInfoPluginResult(kbPaymentId, kbTransactionId, TransactionType.CAPTURE, amount, currency);
    }

    public PaymentTransactionInfoPlugin purchasePayment(UUID accountId, UUID kbPaymentId, UUID kbTransactionId, UUID kbPaymentMethodId, BigDecimal amount, Currency currency, Iterable<PluginProperty> properties, CallContext context) throws PaymentPluginApiException {
        return this.getPaymentTransactionInfoPluginResult(kbPaymentId, kbTransactionId, TransactionType.PURCHASE, amount, currency);
    }

    public PaymentTransactionInfoPlugin refundPayment(UUID accountId, UUID kbPaymentId, UUID kbTransactionId, UUID kbPaymentMethodId, BigDecimal amount, Currency currency, Iterable<PluginProperty> properties, CallContext context) throws PaymentPluginApiException {
        return this.getPaymentTransactionInfoPluginResult(kbPaymentId, kbTransactionId, TransactionType.REFUND, amount, currency);
    }

    private PaymentTransactionInfoPlugin getPaymentTransactionInfoPluginResult(final UUID kbPaymentId, final UUID kbTransactionId, final TransactionType transactionType, final BigDecimal amount, final Currency currency) throws PaymentPluginApiException {
        return this.withRuntimeCheckForExceptions(new PaymentTransactionInfoPlugin(){

            public UUID getKbPaymentId() {
                return kbPaymentId;
            }

            public UUID getKbTransactionPaymentId() {
                return kbTransactionId;
            }

            public TransactionType getTransactionType() {
                return transactionType;
            }

            public BigDecimal getAmount() {
                return amount;
            }

            public Currency getCurrency() {
                return currency;
            }

            public DateTime getCreatedDate() {
                return new DateTime();
            }

            public DateTime getEffectiveDate() {
                return new DateTime();
            }

            public PaymentPluginStatus getStatus() {
                return PaymentPluginStatus.PROCESSED;
            }

            public String getGatewayError() {
                return null;
            }

            public String getGatewayErrorCode() {
                return null;
            }

            public String getFirstPaymentReferenceId() {
                return null;
            }

            public String getSecondPaymentReferenceId() {
                return null;
            }

            public List<PluginProperty> getProperties() {
                return ImmutableList.of();
            }
        });
    }

    public PaymentTransactionInfoPlugin voidPayment(UUID kbAccountId, UUID kbPaymentId, UUID kbTransactionId, UUID kbPaymentMethodId, Iterable<PluginProperty> properties, CallContext context) throws PaymentPluginApiException {
        return this.getPaymentTransactionInfoPluginResult(kbPaymentId, kbTransactionId, TransactionType.VOID, BigDecimal.ZERO, null);
    }

    public PaymentTransactionInfoPlugin creditPayment(UUID kbAccountId, UUID kbPaymentId, UUID kbTransactionId, UUID kbPaymentMethodId, BigDecimal amount, Currency currency, Iterable<PluginProperty> properties, CallContext context) throws PaymentPluginApiException {
        return this.getPaymentTransactionInfoPluginResult(kbPaymentId, kbTransactionId, TransactionType.CREDIT, amount, currency);
    }

    public List<PaymentTransactionInfoPlugin> getPaymentInfo(UUID accountId, UUID kbPaymentId, Iterable<PluginProperty> properties, TenantContext context) throws PaymentPluginApiException {
        BigDecimal someAmount = new BigDecimal("12.45");
        return ImmutableList.of((Object)this.getPaymentTransactionInfoPluginResult(kbPaymentId, UUID.randomUUID(), TransactionType.PURCHASE, someAmount, null));
    }

    public Pagination<PaymentTransactionInfoPlugin> searchPayments(String searchKey, Long offset, Long limit, Iterable<PluginProperty> properties, TenantContext tenantContext) throws PaymentPluginApiException {
        return new Pagination<PaymentTransactionInfoPlugin>(){

            public Long getCurrentOffset() {
                return 0L;
            }

            public Long getNextOffset() {
                return null;
            }

            public Long getMaxNbRecords() {
                return 0L;
            }

            public Long getTotalNbRecords() {
                return 0L;
            }

            public Iterator<PaymentTransactionInfoPlugin> iterator() {
                return null;
            }
        };
    }

    public void addPaymentMethod(UUID kbAccountId, UUID kbPaymentMethodId, PaymentMethodPlugin paymentMethodProps, boolean setDefault, Iterable<PluginProperty> properties, CallContext context) throws PaymentPluginApiException {
    }

    public void deletePaymentMethod(UUID accountId, UUID kbPaymentMethodId, Iterable<PluginProperty> properties, CallContext context) throws PaymentPluginApiException {
    }

    public PaymentMethodPlugin getPaymentMethodDetail(UUID kbAccountId, UUID kbPaymentMethodId, Iterable<PluginProperty> properties, TenantContext context) throws PaymentPluginApiException {
        return null;
    }

    public void setDefaultPaymentMethod(UUID accountId, UUID kbPaymentMethodId, Iterable<PluginProperty> properties, CallContext context) throws PaymentPluginApiException {
    }

    public List<PaymentMethodInfoPlugin> getPaymentMethods(UUID kbAccountId, boolean refreshFromGateway, Iterable<PluginProperty> properties, CallContext context) throws PaymentPluginApiException {
        return Collections.emptyList();
    }

    public Pagination<PaymentMethodPlugin> searchPaymentMethods(String searchKey, Long offset, Long limit, Iterable<PluginProperty> properties, TenantContext tenantContext) throws PaymentPluginApiException {
        return new Pagination<PaymentMethodPlugin>(){

            public Long getCurrentOffset() {
                return 0L;
            }

            public Long getNextOffset() {
                return null;
            }

            public Long getMaxNbRecords() {
                return 0L;
            }

            public Long getTotalNbRecords() {
                return 0L;
            }

            public Iterator<PaymentMethodPlugin> iterator() {
                return null;
            }
        };
    }

    public void resetPaymentMethods(UUID accountId, List<PaymentMethodInfoPlugin> paymentMethods, Iterable<PluginProperty> properties, CallContext callContext) throws PaymentPluginApiException {
    }

    public HostedPaymentPageFormDescriptor buildFormDescriptor(UUID kbAccountId, Iterable<PluginProperty> customFields, Iterable<PluginProperty> properties, CallContext callContext) {
        return null;
    }

    public GatewayNotification processNotification(String notification, Iterable<PluginProperty> properties, CallContext callContext) throws PaymentPluginApiException {
        return null;
    }

    private <T> T withRuntimeCheckForExceptions(T result) throws PaymentPluginApiException {
        if (this.paymentPluginApiExceptionOnNextCalls != null) {
            throw this.paymentPluginApiExceptionOnNextCalls;
        }
        if (this.runtimeExceptionOnNextCalls != null) {
            throw this.runtimeExceptionOnNextCalls;
        }
        return result;
    }

    public void setPaymentPluginApiExceptionOnNextCalls(PaymentPluginApiException e) {
        this.resetToNormalBehavior();
        this.paymentPluginApiExceptionOnNextCalls = e;
    }

    public void setPaymentRuntimeExceptionOnNextCalls(RuntimeException e) {
        this.resetToNormalBehavior();
        this.runtimeExceptionOnNextCalls = e;
    }

    public void resetToNormalBehavior() {
        this.paymentPluginApiExceptionOnNextCalls = null;
        this.runtimeExceptionOnNextCalls = null;
    }
}

