/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.nio.file.Path;
import java.util.Collections;
import org.killbill.billing.osgi.bundles.kpm.KPMClient;
import org.killbill.billing.osgi.bundles.kpm.TestUtils;
import org.killbill.billing.osgi.bundles.kpm.impl.FilesUtils;
import org.killbill.billing.osgi.bundles.kpm.impl.Sha1Checker;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSha1Checker {
    @Test(groups={"fast"})
    public void testDownloadedFileVerified() {
        KPMClient httpClient = (KPMClient)Mockito.mock(KPMClient.class);
        Path validPlugin = TestUtils.copyTestResourceToTemp("sha1", "valid-plugin.jar.txt");
        Path validPluginSha1 = TestUtils.copyTestResourceToTemp("sha1", "valid-plugin.jar.txt.sha1");
        Mockito.when((Object)httpClient.downloadToTempOS("valid", Collections.emptyMap(), new String[]{"plugin", ".jar.sha1"})).thenReturn((Object)validPluginSha1);
        Sha1Checker sha1Checker = new Sha1Checker(httpClient, true);
        boolean result = sha1Checker.isDownloadedFileVerified("valid", Collections.emptyMap(), validPlugin);
        Assert.assertTrue((boolean)result);
        FilesUtils.deleteIfExists((Path)validPlugin);
        FilesUtils.deleteIfExists((Path)validPluginSha1);
        Path invalidPlugin = TestUtils.copyTestResourceToTemp("sha1", "invalid-plugin.jar.txt");
        Path invalidPluginSha1 = TestUtils.copyTestResourceToTemp("sha1", "invalid-plugin.jar.txt.sha1");
        Mockito.when((Object)httpClient.downloadToTempOS("invalid", Collections.emptyMap(), new String[]{"plugin", ".jar.sha1"})).thenReturn((Object)invalidPluginSha1);
        sha1Checker = new Sha1Checker(httpClient, true);
        result = sha1Checker.isDownloadedFileVerified("invalid", Collections.emptyMap(), invalidPlugin);
        Assert.assertFalse((boolean)result);
        FilesUtils.deleteIfExists((Path)invalidPlugin);
        FilesUtils.deleteIfExists((Path)invalidPluginSha1);
    }
}

