/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import org.killbill.billing.osgi.bundles.kpm.impl.PluginNamingResolver;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestPluginNamingResolver {
    @DataProvider(name="createGetVersionFromStringParams")
    Object[][] createGetVersionFromStringParams() {
        return new Object[][]{{"plugin-a-1.2.1.jar", "1.2.1"}, {"plugin-b-1.2.3-SNAPSHOT.jar", "1.2.3"}, {"my.super.plugin.1.2.3-snapshot.jar", "1.2.3"}, {"my.super.plugin.1.2.3-snapshot", "1.2.3"}, {"0.24.1", "0.24.1"}, {"0.25.0-SNAPSHOT", "0.25.0"}};
    }

    @Test(groups={"fast"}, dataProvider="createGetVersionFromStringParams")
    public void testGetVersionFromString(String version, String expectedVersion) {
        String result = PluginNamingResolver.getVersionFromString((String)version);
        Assert.assertEquals((String)result, (String)expectedVersion);
    }

    @DataProvider(name="createGetPluginNameParams")
    Object[][] createGetPluginNameParams() {
        return new Object[][]{{"helloworld", "helloworld-plugin"}, {"super-plugin", "super-plugin-plugin"}, {"this-is-plugin-that-actually-not-plugin", "this-is-plugin-that-actually-not-plugin-plugin"}};
    }

    @Test(groups={"fast"}, dataProvider="createGetPluginNameParams")
    public void testGetPluginName(String pluginKey, String expectedPluginName) {
        PluginNamingResolver pluginNamingResolver = PluginNamingResolver.of((String)pluginKey, (String)"0.0.0");
        Assert.assertEquals((String)pluginNamingResolver.getPluginName(), (String)expectedPluginName);
    }

    @DataProvider(name="createGetPluginVersionParams")
    Object[][] createGetPluginVersionParams() {
        return new Object[][]{{"1.0.0-SNAPSHOT", "not-needed", "1.0.0"}, {"not-a-version", "https://maven.company.com/releases/com/company/killbill/plugins/superplugin/superplugin-1.2.3.jar", "1.2.3"}, {"not-a-version", "https://myapp.com/no-version-involved", "0.0.0"}};
    }

    @Test(groups={"fast"}, dataProvider="createGetPluginVersionParams")
    public void testGetPluginVersion(String pluginVersion, String strContainsVersion, String expectedVersion) {
        PluginNamingResolver namingResolver = PluginNamingResolver.of((String)"helloworld", (String)pluginVersion, (String)strContainsVersion);
        Assert.assertEquals((String)namingResolver.getPluginVersion(), (String)expectedVersion);
    }

    @DataProvider(name="createGetPluginJarFileNameParams")
    Object[][] createGetPluginJarFileNameParams() {
        return new Object[][]{{"helloworld", "1.2.3", "helloworld-plugin-1.2.3.jar"}, {"super-plugin", "1.1.2", "super-plugin-plugin-1.1.2.jar"}, {"snapshot-test", "9.0.1-SNAPSHOT", "snapshot-test-plugin-9.0.1.jar"}};
    }

    @Test(groups={"fast"}, dataProvider="createGetPluginJarFileNameParams")
    public void testGetPluginJarFileName(String pluginKey, String version, String expectedJarFileName) {
        PluginNamingResolver pluginNamingResolver = PluginNamingResolver.of((String)pluginKey, (String)version);
        Assert.assertEquals((String)pluginNamingResolver.getPluginJarFileName(), (String)expectedJarFileName);
    }
}

