/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.util.Map;
import org.killbill.billing.osgi.bundles.kpm.KpmProperties;
import org.killbill.billing.osgi.bundles.kpm.PluginIdentifiersDAO;
import org.killbill.billing.osgi.bundles.kpm.TestUtils;
import org.killbill.billing.osgi.bundles.kpm.impl.FileBasedPluginIdentifiersDAO;
import org.killbill.billing.osgi.bundles.kpm.impl.PluginNamingResolver;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestFileBasedPluginIdentifiersDAO {
    private FileBasedPluginIdentifiersDAO pluginIdentifiersDAO;

    @BeforeMethod(groups={"fast"})
    public void beforeMethod() {
        this.pluginIdentifiersDAO = new FileBasedPluginIdentifiersDAO(new KpmProperties(TestUtils.getTestProperties()));
    }

    @AfterMethod(groups={"fast"})
    public void afterMethod() {
        this.pluginIdentifiersDAO.file.delete();
    }

    @Test(groups={"fast"})
    public void testAdd() {
        Map content = this.pluginIdentifiersDAO.loadFileContent();
        Assert.assertEquals((int)content.size(), (int)0);
        String pluginKey = "testPlugin";
        String version = "1.0";
        PluginNamingResolver pluginNamingResolver = PluginNamingResolver.of((String)"testPlugin", (String)"1.0");
        this.pluginIdentifiersDAO.add("testPlugin", "1.0");
        content = this.pluginIdentifiersDAO.loadFileContent();
        PluginIdentifiersDAO.PluginIdentifierModel pluginIdentifierModel = (PluginIdentifiersDAO.PluginIdentifierModel)content.get("testPlugin");
        Assert.assertEquals((int)content.size(), (int)1);
        Assert.assertNotNull((Object)pluginIdentifierModel);
        Assert.assertEquals((String)pluginIdentifierModel.getPluginName(), (String)pluginNamingResolver.getPluginName());
        Assert.assertEquals((String)pluginIdentifierModel.getVersion(), (String)pluginNamingResolver.getPluginVersion());
    }

    @Test(groups={"fast"})
    public void testRemove() {
        String pluginKey = "testPlugin";
        String version = "1.0";
        this.pluginIdentifiersDAO.add("testPlugin", "1.0");
        this.pluginIdentifiersDAO.remove("testPlugin");
        Map content = this.pluginIdentifiersDAO.loadFileContent();
        Assert.assertEquals((int)content.size(), (int)0);
    }
}

