/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.killbill.billing.osgi.bundles.kpm.KPMClient;
import org.killbill.billing.osgi.bundles.kpm.KpmProperties;
import org.killbill.billing.osgi.bundles.kpm.PluginsDirectoryDAO;
import org.killbill.billing.osgi.bundles.kpm.TestUtils;
import org.killbill.billing.osgi.bundles.kpm.UriResolver;
import org.killbill.billing.osgi.bundles.kpm.impl.DefaultPluginsDirectoryDAO;
import org.killbill.billing.osgi.bundles.kpm.impl.FilesUtils;
import org.killbill.billing.osgi.bundles.kpm.impl.UrlResolverFactory;
import org.killbill.commons.utils.Strings;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestDefaultPluginsDirectoryDAO {
    private Path pluginsDirectoryYml;
    private KPMClient httpClient;
    private UriResolver uriResolver;

    @BeforeMethod(groups={"fast"})
    public void beforeMethod() throws Exception {
        Path pluginsDirYmlInTestRes = TestUtils.getTestPath("yaml").resolve("plugin_directory.yml");
        this.pluginsDirectoryYml = Files.createTempFile("kpm-test", "", new FileAttribute[0]);
        if (Files.notExists(this.pluginsDirectoryYml, new LinkOption[0])) {
            Files.copy(pluginsDirYmlInTestRes, this.pluginsDirectoryYml, new CopyOption[0]);
        }
        this.httpClient = (KPMClient)Mockito.mock(KPMClient.class);
        Mockito.when((Object)this.httpClient.downloadToTempOS(Mockito.anyString(), new String[]{Mockito.anyString(), Mockito.anyString()})).thenReturn((Object)this.pluginsDirectoryYml);
        Mockito.when((Object)this.httpClient.downloadToTempOS(Mockito.anyString(), Mockito.anyMap(), new String[]{Mockito.anyString(), Mockito.anyString()})).thenReturn((Object)this.pluginsDirectoryYml);
        UrlResolverFactory urlResolverFactory = new UrlResolverFactory(new KpmProperties(TestUtils.getTestProperties()));
        this.uriResolver = urlResolverFactory.getPluginDirectoryUrlResolver();
    }

    @AfterMethod(groups={"fast"})
    public void afterMethod() {
        FilesUtils.deleteIfExists((Path)this.pluginsDirectoryYml);
    }

    @Test(groups={"fast"})
    public void testGetPlugins() {
        DefaultPluginsDirectoryDAO pluginsDirectoryDAO = new DefaultPluginsDirectoryDAO(this.httpClient, this.uriResolver, "0.24.0");
        for (PluginsDirectoryDAO.PluginsDirectoryModel availablePlugin : pluginsDirectoryDAO.getPlugins()) {
            Assert.assertNotNull((Object)availablePlugin);
            String pluginKey = availablePlugin.getPluginKey();
            String pluginVersion = availablePlugin.getPluginVersion();
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)pluginKey));
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)pluginVersion));
        }
    }
}

