/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.util.Properties;
import org.killbill.billing.osgi.bundles.kpm.KPMPluginException;
import org.killbill.billing.osgi.bundles.kpm.KpmProperties;
import org.killbill.billing.osgi.bundles.kpm.PluginManager;
import org.killbill.billing.osgi.bundles.kpm.impl.DefaultPluginManager;
import org.killbill.billing.osgi.bundles.kpm.impl.FileBasedPluginIdentifiersDAO;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillAPI;
import org.killbill.billing.util.nodes.KillbillNodesApi;
import org.killbill.billing.util.nodes.NodeInfo;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestDefaultPluginManager {
    private DefaultPluginManager pluginManager;

    @BeforeMethod(groups={"slow"})
    public void beforeMethod() {
        NodeInfo nodeInfo = (NodeInfo)Mockito.mock(NodeInfo.class);
        Mockito.when((Object)nodeInfo.getKillbillVersion()).thenReturn((Object)"0.18.0");
        KillbillNodesApi nodesApi = (KillbillNodesApi)Mockito.mock(KillbillNodesApi.class);
        Mockito.when((Object)nodesApi.getCurrentNodeInfo()).thenReturn((Object)nodeInfo);
        OSGIKillbillAPI osgiKillbillAPI = (OSGIKillbillAPI)Mockito.mock(OSGIKillbillAPI.class);
        Mockito.when((Object)osgiKillbillAPI.getKillbillNodesApi()).thenReturn((Object)nodesApi);
        Properties properties = new Properties();
        properties.setProperty("org.killbill.billing.plugin.kpm.availablePlugins.cache.enabled", "true");
        KpmProperties kpmProperties = new KpmProperties(properties);
        FileBasedPluginIdentifiersDAO pluginIdentifiersDAO = new FileBasedPluginIdentifiersDAO(kpmProperties);
        DefaultPluginManager toSpy = new DefaultPluginManager(osgiKillbillAPI, kpmProperties);
        this.pluginManager = (DefaultPluginManager)Mockito.spy((Object)toSpy);
        ((DefaultPluginManager)Mockito.doReturn((Object)pluginIdentifiersDAO).when((Object)this.pluginManager)).createPluginIdentifiersDAO(kpmProperties);
    }

    @Test(groups={"slow"})
    public void testGetAvailablePlugins() {
        PluginManager.GetAvailablePluginsModel result = this.pluginManager.getAvailablePlugins("0.18.0", true);
        Assert.assertEquals((String)result.getKillbillArtifactsVersion().getKillbill(), (String)"0.18.0");
        Assert.assertFalse((boolean)result.getAvailablePlugins().isEmpty());
        try {
            result = this.pluginManager.getAvailablePlugins("not-exist", true);
            Assert.fail();
        }
        catch (KPMPluginException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Unable to get killbill version info"));
        }
        result = this.pluginManager.getAvailablePlugins("not-exist", false);
        Assert.assertEquals((String)result.getKillbillArtifactsVersion().getKillbill(), (String)"0.0.0");
        Assert.assertTrue((boolean)result.getAvailablePlugins().isEmpty());
    }
}

