/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.killbill.billing.osgi.bundles.kpm.KpmProperties;
import org.killbill.billing.osgi.bundles.kpm.PluginFileService;
import org.killbill.billing.osgi.bundles.kpm.TestUtils;
import org.killbill.billing.osgi.bundles.kpm.impl.DefaultPluginFileService;
import org.killbill.billing.osgi.bundles.kpm.impl.DefaultPluginInstaller;
import org.killbill.billing.osgi.bundles.kpm.impl.FilesUtils;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestDefaultPluginInstaller {
    private static final String SET_DEFAULT_NAME = "SET_DEFAULT";
    private final Path DOWNLOADED_FILE = TestUtils.getTestPath("plugins", "uri-installer-test", "temp", "downloaded-file-jar.txt");
    private Path bundleInstallDir;
    private DefaultPluginInstaller pluginInstaller;

    @BeforeMethod(groups={"fast"})
    public void beforeMethod() throws IOException {
        this.bundleInstallDir = Files.createTempDirectory("test-kpm-plugin-installer", new FileAttribute[0]);
        KpmProperties kpmProperties = TestUtils.getKpmProperties(this.bundleInstallDir.toString(), new Map.Entry[0]);
        DefaultPluginFileService pluginFileService = new DefaultPluginFileService(kpmProperties);
        this.pluginInstaller = new DefaultPluginInstaller((PluginFileService)pluginFileService);
    }

    @AfterMethod(groups={"fast"})
    public void afterMethod() {
        FilesUtils.deleteRecursively((Path)this.bundleInstallDir);
    }

    @Test(groups={"fast"})
    public void testInstall() {
        Assert.assertTrue((boolean)Files.exists(this.DOWNLOADED_FILE, new LinkOption[0]));
        this.pluginInstaller.install(this.DOWNLOADED_FILE, "superjar", "1.0.0-SNAPSHOT");
        Path installedPluginDir = Path.of(this.bundleInstallDir.toString(), "plugins", "java", "superjar-plugin", "1.0.0");
        Path installedPluginFile = installedPluginDir.resolve("superjar-plugin-1.0.0.jar");
        Path symlink = installedPluginDir.getParent().resolve(SET_DEFAULT_NAME);
        Assert.assertTrue((boolean)Files.exists(installedPluginDir, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(installedPluginFile, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.isRegularFile(installedPluginFile, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(symlink, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.isSymbolicLink(symlink));
    }

    @DataProvider(name="testUninstallParams")
    Object[][] testUninstallParams() {
        return new Object[][]{{"1.0.0", "1.0.2"}, {"1.0.1", "1.0.2"}, {"1.0.2", "1.0.1"}};
    }

    @Test(groups={"fast"}, dataProvider="testUninstallParams")
    public void testUninstall(String uninstalledVersion, String setDefaultVersionAfterUninstall) {
        this.beforeTestUninstall();
        this.pluginInstaller.uninstall("superjar", uninstalledVersion);
        Path pluginKeyDir = Path.of(this.bundleInstallDir.toString(), "plugins", "java", "superjar-plugin");
        Path uninstalledPluginDir = pluginKeyDir.resolve(uninstalledVersion);
        Path uninstalledPluginJar = uninstalledPluginDir.resolve("superjar-plugin-" + uninstalledVersion + ".jar");
        Path symlinkAfterUninstall = pluginKeyDir.resolve(SET_DEFAULT_NAME).resolve("superjar-plugin-" + setDefaultVersionAfterUninstall + ".jar");
        Assert.assertFalse((boolean)Files.exists(pluginKeyDir.resolve(uninstalledVersion), new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists(uninstalledPluginDir, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists(uninstalledPluginJar, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(symlinkAfterUninstall, new LinkOption[0]));
    }

    private void beforeTestUninstall() {
        this.pluginInstaller.install(this.DOWNLOADED_FILE, "superjar", "1.0.0");
        this.pluginInstaller.install(this.DOWNLOADED_FILE, "superjar", "1.0.1");
        this.pluginInstaller.install(this.DOWNLOADED_FILE, "superjar", "1.0.2");
        Path pluginKeyDir = Path.of(this.bundleInstallDir.toString(), "plugins", "java", "superjar-plugin");
        Assert.assertTrue((boolean)Files.exists(pluginKeyDir.resolve("1.0.0"), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(pluginKeyDir.resolve("1.0.0").resolve("superjar-plugin-1.0.0.jar"), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(pluginKeyDir.resolve("1.0.1"), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(pluginKeyDir.resolve("1.0.1").resolve("superjar-plugin-1.0.1.jar"), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(pluginKeyDir.resolve("1.0.2"), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(pluginKeyDir.resolve("1.0.2").resolve("superjar-plugin-1.0.2.jar"), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(pluginKeyDir.resolve(SET_DEFAULT_NAME).resolve("superjar-plugin-1.0.2.jar"), new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists(pluginKeyDir.resolve(SET_DEFAULT_NAME).resolve("superjar-plugin-1.0.1.jar"), new LinkOption[0]));
    }
}

