/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.killbill.billing.osgi.bundles.kpm.KpmProperties;
import org.killbill.billing.osgi.bundles.kpm.TestUtils;
import org.killbill.billing.osgi.bundles.kpm.impl.DefaultPluginFileService;
import org.killbill.billing.osgi.bundles.kpm.impl.PluginNamingResolver;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestDefaultPluginFileService {
    private DefaultPluginFileService pluginFileService;

    @BeforeMethod(groups={"fast"})
    public void beforeMethod() {
        this.pluginFileService = new DefaultPluginFileService(new KpmProperties(TestUtils.getTestProperties()));
    }

    @DataProvider(name="createPluginDirectoryParams")
    Object[][] createPluginDirectoryParams() {
        return new Object[][]{{"helloworld", "1.2.1"}, {"super-code", "1.2.3-SNAPSHOT"}, {"CONTAINS_UPPER_CASE", "1.2.3-RC2"}, {"helloworld", "1.2.1"}};
    }

    @Test(groups={"fast"}, dataProvider="createPluginDirectoryParams")
    public void testCreatePluginDirectory(String pluginKey, String pluginVersion) throws IOException {
        Path pluginDirectory = this.pluginFileService.createPluginDirectory(pluginKey, pluginVersion);
        String actualVersion = PluginNamingResolver.getVersionFromString((String)pluginVersion);
        Assert.assertEquals((Iterable)pluginDirectory, (Iterable)TestUtils.getTestPath("plugins", "java", pluginKey + "-plugin", actualVersion));
        Assert.assertTrue((boolean)Files.isDirectory(pluginDirectory, new LinkOption[0]));
    }

    @Test(groups={"fast"})
    public void testCreateSymlink() throws IOException {
        Path pluginDirectory = TestUtils.getTestPath("plugins", "symlink-test");
        Path symlink = pluginDirectory.resolveSibling("SET_DEFAULT");
        this.pluginFileService.createSymlink(pluginDirectory);
        Assert.assertTrue((boolean)Files.isSymbolicLink(symlink));
        Assert.assertEquals((Iterable)Files.readSymbolicLink(symlink), (Iterable)pluginDirectory);
    }
}

