/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.nio.file.Files;
import java.nio.file.Path;
import org.killbill.billing.osgi.bundles.kpm.KPMClient;
import org.killbill.billing.osgi.bundles.kpm.UriResolver;
import org.killbill.billing.osgi.bundles.kpm.impl.DefaultNexusMetadataFiles;
import org.killbill.billing.osgi.bundles.kpm.impl.FilesUtils;
import org.killbill.billing.osgi.bundles.kpm.impl.NoneUriResolver;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestDefaultNexusMetadataFiles {
    private static final String MAVEN_METADATA_XML = "https://repo1.maven.org/maven2/org/kill-bill/billing/killbill/maven-metadata.xml";
    private DefaultNexusMetadataFiles nexusMetadataFiles;
    private KPMClient kpmClient;

    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        this.kpmClient = new KPMClient(true, 30000, 30000);
    }

    @AfterMethod(groups={"slow"})
    public void afterMethod() {
        if (this.nexusMetadataFiles == null) {
            throw new IllegalStateException("Due to previous error, please clean your OS temp directory manually");
        }
        this.nexusMetadataFiles.cleanup();
    }

    private DefaultNexusMetadataFiles spyNexusMetadataFiles(KPMClient kpmClient, UriResolver uriResolver, String mavenMetadataXmlUrl, String kbVersion) {
        DefaultNexusMetadataFiles toSpy = new DefaultNexusMetadataFiles(kpmClient, uriResolver, mavenMetadataXmlUrl, kbVersion);
        return (DefaultNexusMetadataFiles)Mockito.spy((Object)toSpy);
    }

    private void testGetKillbillPomXml(String kbVersion) throws Exception {
        NoneUriResolver uriResolver = new NoneUriResolver("https://oss.sonatype.org/content/repositories/releases");
        this.nexusMetadataFiles = this.spyNexusMetadataFiles(this.kpmClient, (UriResolver)uriResolver, MAVEN_METADATA_XML, kbVersion);
        Path killbillPom = this.nexusMetadataFiles.getKillbillPomXml();
        String content = Files.readString(killbillPom);
        Assert.assertTrue((boolean)content.contains("<artifactId>killbill</artifactId>"));
        FilesUtils.deleteIfExists((Path)killbillPom);
    }

    @Test(groups={"slow"})
    public void testGetKillbillPomXmlWithLatest() throws Exception {
        this.testGetKillbillPomXml("latest");
        ((DefaultNexusMetadataFiles)Mockito.verify((Object)this.nexusMetadataFiles, (VerificationMode)Mockito.times((int)1))).getKillbillUrl();
        ((DefaultNexusMetadataFiles)Mockito.verify((Object)this.nexusMetadataFiles, (VerificationMode)Mockito.times((int)1))).getMavenMetadataXml();
    }

    @Test(groups={"slow"})
    public void testGetKillbillPomXmlWithFixedVersion() throws Exception {
        this.testGetKillbillPomXml("0.24.0");
        ((DefaultNexusMetadataFiles)Mockito.verify((Object)this.nexusMetadataFiles, (VerificationMode)Mockito.times((int)1))).getKillbillUrl();
        ((DefaultNexusMetadataFiles)Mockito.verify((Object)this.nexusMetadataFiles, (VerificationMode)Mockito.times((int)0))).getMavenMetadataXml();
    }

    private void testGetOssParentPomXml(String kbVersion) throws Exception {
        NoneUriResolver uriResolver = new NoneUriResolver("https://oss.sonatype.org/content/repositories/releases");
        this.nexusMetadataFiles = this.spyNexusMetadataFiles(this.kpmClient, (UriResolver)uriResolver, MAVEN_METADATA_XML, kbVersion);
        Path ossParentPomXml = this.nexusMetadataFiles.getOssParentPomXml();
        String content = Files.readString(ossParentPomXml);
        Assert.assertTrue((boolean)content.contains("<artifactId>killbill-oss-parent</artifactId>"));
        FilesUtils.deleteIfExists((Path)ossParentPomXml);
    }

    @Test(groups={"slow"})
    public void testGetOssParentWithLatest() throws Exception {
        this.testGetOssParentPomXml("latest");
        ((DefaultNexusMetadataFiles)Mockito.verify((Object)this.nexusMetadataFiles, (VerificationMode)Mockito.times((int)1))).getKillbillPomXml();
        ((DefaultNexusMetadataFiles)Mockito.verify((Object)this.nexusMetadataFiles, (VerificationMode)Mockito.times((int)1))).getKillbillUrl();
        ((DefaultNexusMetadataFiles)Mockito.verify((Object)this.nexusMetadataFiles, (VerificationMode)Mockito.times((int)1))).getMavenMetadataXml();
    }

    @Test(groups={"slow"})
    public void testGetOssParentWithFixedVersion() throws Exception {
        this.testGetOssParentPomXml("0.24.1");
        ((DefaultNexusMetadataFiles)Mockito.verify((Object)this.nexusMetadataFiles, (VerificationMode)Mockito.times((int)1))).getKillbillPomXml();
        ((DefaultNexusMetadataFiles)Mockito.verify((Object)this.nexusMetadataFiles, (VerificationMode)Mockito.times((int)1))).getKillbillUrl();
        ((DefaultNexusMetadataFiles)Mockito.verify((Object)this.nexusMetadataFiles, (VerificationMode)Mockito.never())).getMavenMetadataXml();
    }
}

