/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.nio.file.Path;
import java.util.Set;
import org.killbill.billing.osgi.api.OSGIKillbill;
import org.killbill.billing.osgi.bundles.kpm.KPMClient;
import org.killbill.billing.osgi.bundles.kpm.KPMPluginException;
import org.killbill.billing.osgi.bundles.kpm.KpmProperties;
import org.killbill.billing.osgi.bundles.kpm.PluginsDirectoryDAO;
import org.killbill.billing.osgi.bundles.kpm.TestUtils;
import org.killbill.billing.osgi.bundles.kpm.VersionsProvider;
import org.killbill.billing.osgi.bundles.kpm.impl.AvailablePluginsComponentsFactory;
import org.killbill.billing.osgi.bundles.kpm.impl.FilesUtils;
import org.killbill.billing.util.nodes.KillbillNodesApi;
import org.killbill.billing.util.nodes.NodeInfo;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestAvailablePluginsComponentsFactory {
    private static final String KILLBILL_POM_REGEX = ".killbill-\\d+\\.\\d+\\.\\d+(-[a-zA-Z0-9]+)?\\.pom$";
    private Path killbillPomXml;
    private Path ossParentPomXml;
    private Path mavenMetadataXml;
    private Path pluginDirectoryYml;
    private NodeInfo nodeInfo;
    private AvailablePluginsComponentsFactory componentsFactory;

    @BeforeMethod(groups={"fast"})
    public void beforeMethod() throws Exception {
        this.killbillPomXml = TestUtils.copyTestResourceToTemp("xml", "killbill-pom.xml");
        this.ossParentPomXml = TestUtils.copyTestResourceToTemp("xml", "ossparent-pom.xml");
        this.mavenMetadataXml = TestUtils.copyTestResourceToTemp("xml", "maven-metadata.xml");
        this.pluginDirectoryYml = TestUtils.copyTestResourceToTemp("/yaml/plugins_directory.yml");
        this.nodeInfo = (NodeInfo)Mockito.mock(NodeInfo.class);
        KillbillNodesApi killbillNodesApi = (KillbillNodesApi)Mockito.mock(KillbillNodesApi.class);
        Mockito.when((Object)killbillNodesApi.getCurrentNodeInfo()).thenReturn((Object)this.nodeInfo);
        OSGIKillbill osgiKillbill = (OSGIKillbill)Mockito.mock(OSGIKillbill.class);
        Mockito.when((Object)osgiKillbill.getKillbillNodesApi()).thenReturn((Object)killbillNodesApi);
        KPMClient httpClient = (KPMClient)Mockito.mock(KPMClient.class);
        Mockito.when((Object)httpClient.downloadToTempOS(Mockito.contains((String)"plugins_directory"), new String[]{Mockito.anyString(), Mockito.anyString()})).thenReturn((Object)this.pluginDirectoryYml);
        Mockito.when((Object)httpClient.downloadToTempOS(Mockito.contains((String)"plugins_directory"), Mockito.anyMap(), new String[]{Mockito.anyString(), Mockito.anyString()})).thenReturn((Object)this.pluginDirectoryYml);
        Mockito.when((Object)httpClient.downloadToTempOS(Mockito.contains((String)"maven-metadata"), new String[]{Mockito.anyString(), Mockito.anyString()})).thenReturn((Object)this.mavenMetadataXml);
        Mockito.when((Object)httpClient.downloadToTempOS(Mockito.contains((String)"maven-metadata"), Mockito.anyMap(), new String[]{Mockito.anyString(), Mockito.anyString()})).thenReturn((Object)this.mavenMetadataXml);
        Mockito.when((Object)httpClient.downloadToTempOS(Mockito.contains((String)"killbill-oss-parent"), Mockito.anyMap(), new String[]{Mockito.anyString(), Mockito.anyString()})).thenReturn((Object)this.ossParentPomXml);
        Mockito.when((Object)httpClient.downloadToTempOS(Mockito.matches((String)KILLBILL_POM_REGEX), Mockito.anyMap(), new String[]{Mockito.anyString(), Mockito.anyString()})).thenReturn((Object)this.killbillPomXml);
        this.componentsFactory = new AvailablePluginsComponentsFactory(osgiKillbill, httpClient, new KpmProperties(TestUtils.getTestProperties()));
    }

    @AfterMethod(groups={"fast"})
    public void afterMethod() {
        FilesUtils.deleteIfExists((Path)this.killbillPomXml);
        FilesUtils.deleteIfExists((Path)this.ossParentPomXml);
        FilesUtils.deleteIfExists((Path)this.mavenMetadataXml);
        FilesUtils.deleteIfExists((Path)this.pluginDirectoryYml);
    }

    @Test(groups={"fast"})
    public void testCreateVersionsProviderWithoutNodeInfo() {
        Mockito.when((Object)this.nodeInfo.getKillbillVersion()).thenReturn((Object)"0.0.0");
        VersionsProvider versionsProvider = this.componentsFactory.createVersionsProvider("laTEst", true);
        Assert.assertEquals((String)versionsProvider.getFixedKillbillVersion(), (String)"0.24.1-SNAPSHOT");
        Assert.assertEquals((String)versionsProvider.getOssParentVersion(), (String)"0.146.6");
        Assert.assertEquals((String)versionsProvider.getKillbillApiVersion(), (String)"0.54.0");
        Assert.assertEquals((String)versionsProvider.getKillbillPluginApiVersion(), (String)"0.27.0");
        Assert.assertEquals((String)versionsProvider.getKillbillCommonsVersion(), (String)"0.25.1-209ec51-SNAPSHOT");
        Assert.assertEquals((String)versionsProvider.getKillbillPlatformVersion(), (String)"0.41.0-1461460-SNAPSHOT");
    }

    @Test(groups={"fast"})
    public void testCreateVersionsProviderWithNodeInfo() {
        Mockito.when((Object)this.nodeInfo.getKillbillVersion()).thenReturn((Object)"0.24.1-SNAPSHOT");
        Mockito.when((Object)this.nodeInfo.getApiVersion()).thenReturn((Object)"1.0-node-info");
        Mockito.when((Object)this.nodeInfo.getPluginApiVersion()).thenReturn((Object)"1.0-node-info");
        Mockito.when((Object)this.nodeInfo.getCommonVersion()).thenReturn((Object)"1.0-node-info");
        Mockito.when((Object)this.nodeInfo.getPlatformVersion()).thenReturn((Object)"1.0-node-info");
        VersionsProvider versionsProvider = this.componentsFactory.createVersionsProvider("0.24.1-SNAPSHOT", true);
        Assert.assertEquals((String)versionsProvider.getFixedKillbillVersion(), (String)"0.24.1-SNAPSHOT");
        Assert.assertEquals((String)versionsProvider.getOssParentVersion(), (String)"0.146.6");
        Assert.assertEquals((String)versionsProvider.getKillbillApiVersion(), (String)"1.0-node-info");
        Assert.assertEquals((String)versionsProvider.getKillbillPluginApiVersion(), (String)"1.0-node-info");
        Assert.assertEquals((String)versionsProvider.getKillbillCommonsVersion(), (String)"1.0-node-info");
        Assert.assertEquals((String)versionsProvider.getKillbillPlatformVersion(), (String)"1.0-node-info");
    }

    @Test(groups={"fast"})
    public void testCreatePluginsDirectoryDAO() throws KPMPluginException {
        PluginsDirectoryDAO pluginsDirectoryDAO = this.componentsFactory.createPluginsDirectoryDAO("0.24.2-SNAPSHOT", true);
        Assert.assertNotNull((Object)pluginsDirectoryDAO);
        Set plugins = pluginsDirectoryDAO.getPlugins();
        Assert.assertNotNull((Object)plugins);
        Assert.assertFalse((boolean)plugins.isEmpty());
    }
}

