/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.util.Optional;
import org.killbill.billing.osgi.bundles.kpm.PluginIdentifiersDAO;
import org.killbill.billing.osgi.bundles.kpm.impl.ArtifactAndVersionFinder;
import org.killbill.billing.osgi.bundles.kpm.impl.AvailablePluginsComponentsFactory;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestArtifactAndVersionFinder {
    private ArtifactAndVersionFinder artifactAndVersionFinder;

    @BeforeMethod(groups={"fast"})
    public void beforeMethod() {
        PluginIdentifiersDAO pluginIdentifiersDAO = (PluginIdentifiersDAO)Mockito.mock(PluginIdentifiersDAO.class);
        AvailablePluginsComponentsFactory factory = (AvailablePluginsComponentsFactory)Mockito.mock(AvailablePluginsComponentsFactory.class);
        ArtifactAndVersionFinder toSpy = new ArtifactAndVersionFinder(pluginIdentifiersDAO, factory);
        this.artifactAndVersionFinder = (ArtifactAndVersionFinder)Mockito.spy((Object)toSpy);
    }

    @Test(groups={"fast"})
    public void findArtifactAndVersionWithNonNullInput() {
        Optional result = this.artifactAndVersionFinder.findArtifactAndVersion("0.24.0", "test-plugin-key", "test-artifact-id", "1.0.0", true);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertTrue((boolean)((ArtifactAndVersionFinder.ArtifactAndVersionModel)result.get()).isAttributesSet());
        Assert.assertEquals((String)((ArtifactAndVersionFinder.ArtifactAndVersionModel)result.get()).getArtifactId(), (String)"test-artifact-id");
        Assert.assertEquals((String)((ArtifactAndVersionFinder.ArtifactAndVersionModel)result.get()).getVersion(), (String)"1.0.0");
    }

    @Test(groups={"fast"})
    public void findArtifactAndVersionWithSearchFromPluginsIdentifier() {
        ArtifactAndVersionFinder.ArtifactAndVersionModel model = new ArtifactAndVersionFinder.ArtifactAndVersionModel("artifact-from-plugin-identifier", "1.2.3");
        ((ArtifactAndVersionFinder)Mockito.doReturn((Object)model).when((Object)this.artifactAndVersionFinder)).searchFromPluginsIdentifier("test-plugin-key", false);
        Optional result = this.artifactAndVersionFinder.findArtifactAndVersion("0.24.0", "test-plugin-key", null, null, false);
        ((ArtifactAndVersionFinder)Mockito.verify((Object)this.artifactAndVersionFinder, (VerificationMode)Mockito.times((int)1))).searchFromPluginsIdentifier("test-plugin-key", false);
        ((ArtifactAndVersionFinder)Mockito.verify((Object)this.artifactAndVersionFinder, (VerificationMode)Mockito.never())).searchFromPluginsDirectory("0.24.0", "test-plugin-key", true);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertTrue((boolean)((ArtifactAndVersionFinder.ArtifactAndVersionModel)result.get()).isAttributesSet());
        Assert.assertEquals((String)((ArtifactAndVersionFinder.ArtifactAndVersionModel)result.get()).getArtifactId(), (String)"artifact-from-plugin-identifier");
        Assert.assertEquals((String)((ArtifactAndVersionFinder.ArtifactAndVersionModel)result.get()).getVersion(), (String)"1.2.3");
    }

    @Test(groups={"fast"})
    public void findArtifactAndVersionWithSearchFromAvailablePlugins() {
        ((ArtifactAndVersionFinder)Mockito.doReturn((Object)new ArtifactAndVersionFinder.ArtifactAndVersionModel(null, null)).when((Object)this.artifactAndVersionFinder)).searchFromPluginsIdentifier("test-plugin-key", false);
        ((ArtifactAndVersionFinder)Mockito.doReturn((Object)new ArtifactAndVersionFinder.ArtifactAndVersionModel("artifact-from-available-plugin", "4.5.6")).when((Object)this.artifactAndVersionFinder)).searchFromPluginsDirectory("0.24.0", "test-plugin-key", true);
        Optional result = this.artifactAndVersionFinder.findArtifactAndVersion("0.24.0", "test-plugin-key", null, null, true);
        ((ArtifactAndVersionFinder)Mockito.verify((Object)this.artifactAndVersionFinder, (VerificationMode)Mockito.times((int)1))).searchFromPluginsIdentifier("test-plugin-key", true);
        ((ArtifactAndVersionFinder)Mockito.verify((Object)this.artifactAndVersionFinder, (VerificationMode)Mockito.times((int)1))).searchFromPluginsDirectory("0.24.0", "test-plugin-key", true);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertTrue((boolean)((ArtifactAndVersionFinder.ArtifactAndVersionModel)result.get()).isAttributesSet());
        Assert.assertEquals((String)((ArtifactAndVersionFinder.ArtifactAndVersionModel)result.get()).getArtifactId(), (String)"artifact-from-available-plugin");
        Assert.assertEquals((String)((ArtifactAndVersionFinder.ArtifactAndVersionModel)result.get()).getVersion(), (String)"4.5.6");
    }

    @Test(groups={"fast"})
    public void findArtifactAndVersionWithSearchFromPluginsIdentifierFirst() {
        ((ArtifactAndVersionFinder)Mockito.doReturn((Object)new ArtifactAndVersionFinder.ArtifactAndVersionModel("artifact-plugins-id-first", "10.0.0")).when((Object)this.artifactAndVersionFinder)).searchFromPluginsIdentifier("test-plugin-key", false);
        ((ArtifactAndVersionFinder)Mockito.doReturn((Object)new ArtifactAndVersionFinder.ArtifactAndVersionModel("artifact-plugins-id-first", "10.0.0")).when((Object)this.artifactAndVersionFinder)).searchFromPluginsDirectory("0.24.0", "test-plugin-key", true);
        Optional result = this.artifactAndVersionFinder.findArtifactAndVersion("0.24.0", "test-plugin-key", null, null, false);
        ((ArtifactAndVersionFinder)Mockito.verify((Object)this.artifactAndVersionFinder, (VerificationMode)Mockito.times((int)1))).searchFromPluginsIdentifier("test-plugin-key", false);
        ((ArtifactAndVersionFinder)Mockito.verify((Object)this.artifactAndVersionFinder, (VerificationMode)Mockito.never())).searchFromPluginsDirectory("0.24.0", "test-plugin-key", true);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertTrue((boolean)((ArtifactAndVersionFinder.ArtifactAndVersionModel)result.get()).isAttributesSet());
        Assert.assertEquals((String)((ArtifactAndVersionFinder.ArtifactAndVersionModel)result.get()).getArtifactId(), (String)"artifact-plugins-id-first");
        Assert.assertEquals((String)((ArtifactAndVersionFinder.ArtifactAndVersionModel)result.get()).getVersion(), (String)"10.0.0");
    }

    @Test(groups={"fast"})
    public void findArtifactAndVersionWithNoSearchResult() {
        ((ArtifactAndVersionFinder)Mockito.doReturn((Object)new ArtifactAndVersionFinder.ArtifactAndVersionModel(null, null)).when((Object)this.artifactAndVersionFinder)).searchFromPluginsIdentifier("test-plugin-key", false);
        ((ArtifactAndVersionFinder)Mockito.doReturn((Object)new ArtifactAndVersionFinder.ArtifactAndVersionModel(null, null)).when((Object)this.artifactAndVersionFinder)).searchFromPluginsDirectory("0.24.0", "test-plugin-key", true);
        Optional result = this.artifactAndVersionFinder.findArtifactAndVersion("0.24.0", "test-plugin-key", null, null, true);
        ((ArtifactAndVersionFinder)Mockito.verify((Object)this.artifactAndVersionFinder, (VerificationMode)Mockito.times((int)1))).searchFromPluginsIdentifier("test-plugin-key", true);
        ((ArtifactAndVersionFinder)Mockito.verify((Object)this.artifactAndVersionFinder, (VerificationMode)Mockito.times((int)1))).searchFromPluginsDirectory("0.24.0", "test-plugin-key", true);
        Assert.assertTrue((boolean)result.isEmpty());
    }
}

