/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.killbill.billing.osgi.bundles.kpm.impl.FilesUtils;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FilesUtilsTest {
    private static final Path ACTUAL_SYMLINK_PATH;
    private Path dirToDelete;

    @BeforeMethod(groups={"fast"})
    public void beforeMethod() throws IOException {
        this.dirToDelete = Files.createTempDirectory("test-file-utils", new FileAttribute[0]);
        Files.createDirectories(this.dirToDelete.resolve("file"), new FileAttribute[0]);
        Files.createDirectories(this.dirToDelete.resolve("util"), new FileAttribute[0]);
        Files.createFile(this.dirToDelete.resolve("util").resolve("file.txt"), new FileAttribute[0]);
        Files.createSymbolicLink(this.dirToDelete.resolve("link"), ACTUAL_SYMLINK_PATH, new FileAttribute[0]);
        Assert.assertTrue((boolean)Files.exists(ACTUAL_SYMLINK_PATH, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(this.dirToDelete, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(this.dirToDelete.resolve("file"), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(this.dirToDelete.resolve("util"), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(this.dirToDelete.resolve("util").resolve("file.txt"), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(this.dirToDelete.resolve("link"), new LinkOption[0]));
    }

    @AfterMethod(groups={"fast"})
    public void afterMethod() {
        FilesUtils.deleteIfExists((Path)ACTUAL_SYMLINK_PATH);
    }

    @Test(groups={"fast"})
    public void testDeleteRecursively() {
        FilesUtils.deleteRecursively((Path)this.dirToDelete);
        Assert.assertFalse((boolean)Files.exists(this.dirToDelete, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(ACTUAL_SYMLINK_PATH, new LinkOption[0]));
    }

    static {
        try {
            ACTUAL_SYMLINK_PATH = Files.createTempDirectory("test-file-utils-not-deleted", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

