/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import org.killbill.billing.osgi.bundles.kpm.KpmProperties;
import org.killbill.commons.utils.io.Resources;

public class TestUtils {
    public static Path getTestPath(String ... path) {
        return Path.of(Resources.getResource((String)".").getPath(), path);
    }

    public static Path copyTestResourceToTemp(String ... testResourceFile) {
        try {
            Path source = TestUtils.getTestPath(testResourceFile);
            Path target = Files.createTempFile("kpm-test", "", new FileAttribute[0]);
            return Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Properties getTestProperties() {
        Properties properties = new Properties();
        properties.setProperty("org.killbill.osgi.bundle.install.dir", TestUtils.getTestPath(new String[0]).toString());
        return properties;
    }

    @SafeVarargs
    public static KpmProperties getKpmProperties(String bundleInstallDir, Map.Entry<String, String> ... additionalProperties) {
        Properties properties = new Properties();
        properties.setProperty("org.killbill.osgi.bundle.install.dir", bundleInstallDir);
        if (additionalProperties != null) {
            for (Map.Entry<String, String> entry : additionalProperties) {
                properties.setProperty(entry.getKey(), entry.getValue());
            }
        }
        return new KpmProperties(properties);
    }
}

