/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Map;
import org.killbill.billing.osgi.bundles.kpm.KPMClient;
import org.killbill.billing.osgi.bundles.kpm.impl.FilesUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestKPMClient {
    private static final String PLUGIN_DIR = "https://raw.githubusercontent.com/killbill/killbill-cloud/master/kpm/lib/kpm/plugins_directory.yml";
    private static final String GITHUB_URL = "https://maven.pkg.github.com/killbill/qualpay-java-client/org/kill-bill/billing/thirdparty/qualpay-java-client/1.1.9/qualpay-java-client-1.1.9.pom";
    private static final String CLOUDSMITH_URL = "https://dl.cloudsmith.io/basic/some-org/testing/maven/org/kill-bill/billing/plugin/java/hello-world-plugin/2.0.1-SNAPSHOT/hello-world-plugin-2.0.1-20230412.141435-1.jar";
    private static final String CLOUDSMITH_TOKEN_URL = "https://dl.cloudsmith.io/%s/killbill/%s/raw/files/maven-metadata.xml";
    private KPMClient kpmClient;

    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws GeneralSecurityException {
        this.kpmClient = new KPMClient(false, 60000, 60000);
    }

    private Map<String, String> basicAuth(String plainCredentials) {
        String encoded = Base64.getEncoder().encodeToString(plainCredentials.getBytes(StandardCharsets.UTF_8));
        return Map.of("Authorization", "Basic " + encoded);
    }

    private Map<String, String> tokenAuth(String token) {
        return Map.of("Authorization", "token " + token);
    }

    @Test(groups={"slow"})
    public void testPluginsDirectory() {
        Path result = null;
        try {
            result = this.kpmClient.downloadToTempOS(PLUGIN_DIR, new String[]{"test-plugins_directory", ".yml"});
            Assert.assertTrue((Files.size(result) > 0L ? 1 : 0) != 0);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FilesUtils.deleteIfExists(result);
                throw throwable;
            }
        }
        FilesUtils.deleteIfExists((Path)result);
    }

    @Test(groups={"slow"}, enabled=false, description="set 'plainCreds' properly before running")
    public void testGithub() {
        String plainCreds = "<github-username>:<github-key-whatever>";
        Path result = null;
        try {
            result = this.kpmClient.downloadToTempOS(GITHUB_URL, this.basicAuth("<github-username>:<github-key-whatever>"), new String[]{"test-github", ".jar"});
            Assert.assertTrue((Files.size(result) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FilesUtils.deleteIfExists(result);
                throw throwable;
            }
        }
        FilesUtils.deleteIfExists((Path)result);
    }

    @Test(groups={"slow"}, enabled=false, description="set 'plainCreds' properly before running")
    public void testCloudsmith() {
        String plainCreds = "<cloudsmith-username>:<password>";
        Path result = null;
        try {
            result = this.kpmClient.downloadToTempOS(CLOUDSMITH_URL, this.basicAuth("<cloudsmith-username>:<password>"), new String[]{"test-cloudsmith", ".jar"});
            Assert.assertTrue((Files.size(result) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FilesUtils.deleteIfExists(result);
                throw throwable;
            }
        }
        FilesUtils.deleteIfExists((Path)result);
    }

    @Test(groups={"slow"}, enabled=false, description="set 'token' and 'userSpecificsToken' properly before running")
    public void testCloudsmithWithToken() {
        String token = "<cloudsmith-user-api-key>";
        String userSpecificsToken = "<your-cloudsmith-url-key>";
        String repositoryName = "<your-repository-name>";
        Path result = null;
        try {
            result = this.kpmClient.downloadToTempOS(String.format(CLOUDSMITH_TOKEN_URL, "<your-cloudsmith-url-key>", "<your-repository-name>"), this.tokenAuth("<cloudsmith-user-api-key>"), new String[]{"maven-metadata", ".xml"});
            String content = Files.readString(result);
            Assert.assertFalse((boolean)content.isEmpty());
            Assert.assertTrue((boolean)content.contains("latest"));
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FilesUtils.deleteIfExists(result);
                throw throwable;
            }
        }
        FilesUtils.deleteIfExists((Path)result);
    }
}

