/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.utils.collect;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.stream.Collectors;
import org.killbill.commons.utils.Preconditions;

public class EvictingQueue<E>
implements Queue<E> {
    private final int maxSize;
    private final Queue<E> delegate;

    public EvictingQueue(int maxSize) {
        this.maxSize = maxSize;
        this.delegate = new ArrayDeque();
    }

    public int remainingCapacity() {
        return this.maxSize - this.size();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.delegate.toArray(array);
    }

    @Override
    public boolean add(E element) {
        Preconditions.checkNotNull(element);
        if (this.maxSize == 0) {
            return true;
        }
        if (this.size() == this.maxSize) {
            this.delegate.remove();
        }
        this.delegate.add(element);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.delegate.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        int size = collection.size();
        if (size >= this.maxSize) {
            this.clear();
            collection.stream().skip(size - this.maxSize).collect(Collectors.toUnmodifiableList()).forEach(this::add);
        } else {
            collection.forEach(this::add);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    @Override
    public E remove() {
        return this.delegate.remove();
    }

    @Override
    public E poll() {
        return this.delegate.poll();
    }

    @Override
    public E element() {
        return this.delegate.element();
    }

    @Override
    public E peek() {
        return this.delegate.peek();
    }
}

