/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.utils.collect;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import org.killbill.commons.utils.Preconditions;

class ConcatenatedIterator<T>
implements Iterator<T> {
    @CheckForNull
    private Iterator<? extends T> toRemove;
    private Iterator<? extends T> iterator = Collections.emptyIterator();
    @CheckForNull
    private Iterator<? extends Iterator<? extends T>> topMetaIterator;
    @CheckForNull
    private Deque<Iterator<? extends Iterator<? extends T>>> metaIterators;

    ConcatenatedIterator(Iterator<? extends Iterator<? extends T>> metaIterator) {
        this.topMetaIterator = Preconditions.checkNotNull(metaIterator);
    }

    @CheckForNull
    private Iterator<? extends Iterator<? extends T>> getTopMetaIterator() {
        while (this.topMetaIterator == null || !this.topMetaIterator.hasNext()) {
            if (this.metaIterators != null && !this.metaIterators.isEmpty()) {
                this.topMetaIterator = this.metaIterators.removeFirst();
                continue;
            }
            return null;
        }
        return this.topMetaIterator;
    }

    @Override
    public boolean hasNext() {
        while (!Preconditions.checkNotNull(this.iterator).hasNext()) {
            this.topMetaIterator = this.getTopMetaIterator();
            if (this.topMetaIterator == null) {
                return false;
            }
            this.iterator = this.topMetaIterator.next();
            if (!(this.iterator instanceof ConcatenatedIterator)) continue;
            ConcatenatedIterator topConcat = (ConcatenatedIterator)this.iterator;
            this.iterator = topConcat.iterator;
            if (this.metaIterators == null) {
                this.metaIterators = new ArrayDeque<Iterator<? extends Iterator<? extends T>>>();
            }
            this.metaIterators.addFirst(this.topMetaIterator);
            if (topConcat.metaIterators != null) {
                while (!topConcat.metaIterators.isEmpty()) {
                    Preconditions.checkNotNull(this.metaIterators).addFirst(Preconditions.checkNotNull(topConcat.metaIterators.removeLast()));
                }
            }
            this.topMetaIterator = topConcat.topMetaIterator;
        }
        return true;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            this.toRemove = this.iterator;
            return this.iterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (this.toRemove == null) {
            throw new IllegalStateException("no calls to next() since the last call to remove()");
        }
        this.toRemove.remove();
        this.toRemove = null;
    }
}

