/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.utils.cache;

import java.util.Objects;
import org.killbill.commons.utils.Preconditions;

class TimedValue<V> {
    private final long expireTime;
    private final V value;

    TimedValue(long timeoutMillis, V value) {
        this.expireTime = System.currentTimeMillis() + timeoutMillis;
        this.value = Preconditions.checkNotNull(value, "TimedValue.value cannot be null");
    }

    boolean isTimeout() {
        return System.currentTimeMillis() >= this.expireTime;
    }

    V getValue() {
        return this.value;
    }

    public String toString() {
        return "TimedValue {expireTime=" + this.expireTime + ", value=" + this.value + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimedValue that = (TimedValue)o;
        return this.expireTime == that.expireTime && this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.expireTime, this.value);
    }
}

