/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;

public final class Strings {
    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String emptyToNull(String string) {
        return Strings.isNullOrEmpty(string) ? null : string;
    }

    public static List<String> split(String string, String separator) {
        if (Strings.isNullOrEmpty(string)) {
            return Collections.emptyList();
        }
        return Stream.of(string.split(separator)).filter(s2 -> !s2.isBlank()).map(String::trim).collect(Collectors.toUnmodifiableList());
    }

    public static String nullToEmpty(@CheckForNull String string) {
        return string == null ? "" : string;
    }

    public static boolean containsUpperCase(String str) {
        if (Strings.isNullOrEmpty(str)) {
            return false;
        }
        return !str.equals(str.toLowerCase());
    }

    public static String toCamelCase(String str, boolean capitalizeFirstLetter, char ... delimiters) {
        if (str == null || str.isBlank()) {
            return str;
        }
        str = str.toLowerCase();
        int strLen = str.length();
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        Set<Integer> delimiterSet = Strings.toDelimiterSet(delimiters);
        boolean capitalizeNext = capitalizeFirstLetter;
        int index = 0;
        while (index < strLen) {
            int codePoint = str.codePointAt(index);
            if (delimiterSet.contains(codePoint)) {
                capitalizeNext = outOffset != 0;
                index += Character.charCount(codePoint);
                continue;
            }
            if (capitalizeNext || outOffset == 0 && capitalizeFirstLetter) {
                int titleCaseCodePoint = Character.toTitleCase(codePoint);
                newCodePoints[outOffset++] = titleCaseCodePoint;
                index += Character.charCount(titleCaseCodePoint);
                capitalizeNext = false;
                continue;
            }
            newCodePoints[outOffset++] = codePoint;
            index += Character.charCount(codePoint);
        }
        return new String(newCodePoints, 0, outOffset);
    }

    private static Set<Integer> toDelimiterSet(char[] delimiters) {
        HashSet<Integer> delimiterHashSet = new HashSet<Integer>();
        delimiterHashSet.add(Character.codePointAt(new char[]{' '}, 0));
        if (delimiters == null || delimiters.length == 0) {
            return delimiterHashSet;
        }
        for (int index = 0; index < delimiters.length; ++index) {
            delimiterHashSet.add(Character.codePointAt(delimiters, index));
        }
        return delimiterHashSet;
    }

    public static String toSnakeCase(String str) {
        StringBuilder result = new StringBuilder();
        boolean lastUppercase = false;
        for (int i = 0; i < str.length(); ++i) {
            int lastEntry;
            char ch = str.charAt(i);
            int n = lastEntry = i == 0 ? 88 : (int)result.charAt(result.length() - 1);
            if (ch == '_') {
                lastUppercase = false;
                if (lastEntry == 95) continue;
                ch = '_';
            } else if (Character.isUpperCase(ch)) {
                ch = Character.toLowerCase(ch);
                if (i > 0) {
                    if (lastUppercase) {
                        if (i + 1 < str.length()) {
                            char next = str.charAt(i + 1);
                            if (!Character.isUpperCase(next) && Character.isAlphabetic(next)) {
                                if (lastEntry != 95) {
                                    result.append('_');
                                }
                            } else {
                                result.append('_');
                            }
                        }
                    } else if (lastEntry != 95) {
                        result.append('_');
                    }
                }
                lastUppercase = true;
            } else {
                lastUppercase = false;
            }
            result.append(ch);
        }
        return result.toString();
    }
}

