/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.utils;

import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Preconditions {
    private static final Logger logger = LoggerFactory.getLogger(Preconditions.class);

    public static void checkState(boolean expression, @CheckForNull Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalStateException(Preconditions.lenientFormat(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static <T> T checkNotNull(@CheckForNull T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference == null) {
            throw new NullPointerException(Preconditions.lenientFormat(errorMessageTemplate, errorMessageArgs));
        }
        return reference;
    }

    public static void checkState(boolean b, String errorMessageTemplate, @CheckForNull Object p1) {
        if (!b) {
            throw new IllegalStateException(Preconditions.lenientFormat(errorMessageTemplate, p1));
        }
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T checkNotNull(@CheckForNull T reference, @CheckForNull Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public static <T> T checkNotNull(@CheckForNull T obj, String errorMessageTemplate, @CheckForNull Object p1) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.lenientFormat(errorMessageTemplate, p1));
        }
        return obj;
    }

    private static String lenientFormat(@CheckForNull String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        if (args == null) {
            args = new Object[]{"(Object[])null"};
        } else {
            for (int i = 0; i < args.length; ++i) {
                args[i] = Preconditions.lenientToString(args[i]);
            }
        }
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    private static String lenientToString(@CheckForNull Object o) {
        if (o == null) {
            return "null";
        }
        try {
            return o.toString();
        }
        catch (Exception e) {
            String objectToString = o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
            logger.warn("Exception during lenientFormat for {}, {}", (Object)objectToString, (Object)e);
            return "<" + objectToString + " threw " + e.getClass().getName() + ">";
        }
    }

    @Deprecated
    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, Object p1, int p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.lenientFormat(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(boolean b, String errorMessageTemplate, Object p1, Object p2, Object p3) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.lenientFormat(errorMessageTemplate, p1, p2, p3));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(Preconditions.lenientFormat(errorMessageTemplate, errorMessageArgs));
        }
    }
}

