/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.utils;

import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.killbill.commons.utils.Preconditions;

public final class Joiner {
    private final String separator;

    public static Joiner on(String separator) {
        return new Joiner(separator);
    }

    public static Joiner on(char separator) {
        return new Joiner(String.valueOf(separator));
    }

    private Joiner(String separator) {
        this.separator = Preconditions.checkNotNull(separator);
    }

    public String join(Iterable<?> parts) {
        return this.join(parts.iterator());
    }

    public String join(Iterator<?> parts) {
        return this.appendTo((Appendable)new StringBuilder(), parts).toString();
    }

    public StringBuilder appendTo(StringBuilder builder, Iterator<?> parts) {
        try {
            this.appendTo((Appendable)builder, parts);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
        return builder;
    }

    public <A extends Appendable> A appendTo(A appendable, Iterator<?> parts) throws IOException {
        Preconditions.checkNotNull(appendable);
        if (parts.hasNext()) {
            appendable.append(this.toString(parts.next()));
            while (parts.hasNext()) {
                appendable.append(this.separator);
                appendable.append(this.toString(parts.next()));
            }
        }
        return appendable;
    }

    CharSequence toString(Object part) {
        Objects.requireNonNull(part);
        return part instanceof CharSequence ? (CharSequence)part : part.toString();
    }

    public String join(@CheckForNull Object first, @CheckForNull Object second, Object ... rest) {
        return this.join(Joiner.iterable(first, second, rest));
    }

    private static Iterable<Object> iterable(final Object first, final Object second, final Object[] rest) {
        Preconditions.checkNotNull(rest);
        return new AbstractList<Object>(){

            @Override
            public int size() {
                return rest.length + 2;
            }

            @Override
            @CheckForNull
            public Object get(int index) {
                switch (index) {
                    case 0: {
                        return first;
                    }
                    case 1: {
                        return second;
                    }
                }
                return rest[index - 2];
            }
        };
    }
}

