/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.eventbus;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.CheckForNull;
import org.killbill.commons.eventbus.EventBus;
import org.killbill.commons.eventbus.Subscribe;
import org.killbill.commons.eventbus.Subscriber;
import org.killbill.commons.utils.Preconditions;
import org.killbill.commons.utils.Primitives;
import org.killbill.commons.utils.TypeToken;
import org.killbill.commons.utils.annotation.VisibleForTesting;
import org.killbill.commons.utils.cache.Cache;
import org.killbill.commons.utils.cache.DefaultSynchronizedCache;
import org.killbill.commons.utils.collect.Iterators;
import org.killbill.commons.utils.collect.MultiValueHashMap;
import org.killbill.commons.utils.collect.MultiValueMap;

final class SubscriberRegistry {
    private final ConcurrentMap<Class<?>, CopyOnWriteArraySet<Subscriber>> subscribers = new ConcurrentHashMap();
    private final EventBus bus;
    private static final Cache<Class<?>, List<Method>> subscriberMethodsCache = new DefaultSynchronizedCache<Class, List>(Integer.MAX_VALUE, 0L, SubscriberRegistry::getAnnotatedMethodsNotCached);
    private static final Cache<Class<?>, Set<Class<?>>> flattenHierarchyCache = new DefaultSynchronizedCache<Class, Set>(Integer.MAX_VALUE, 0L, key -> new LinkedHashSet(TypeToken.getRawTypes(key)));

    SubscriberRegistry(EventBus bus) {
        this.bus = Preconditions.checkNotNull(bus);
    }

    void register(Object listener) {
        MultiValueMap<Class<?>, Subscriber> listenerMethods = this.findAllSubscribers(listener);
        for (Map.Entry entry : listenerMethods.entrySet()) {
            Class eventType = (Class)entry.getKey();
            Collection eventMethodsInListener = (Collection)entry.getValue();
            CopyOnWriteArraySet eventSubscribers = (CopyOnWriteArraySet)this.subscribers.get(eventType);
            if (eventSubscribers == null) {
                CopyOnWriteArraySet newSet = new CopyOnWriteArraySet();
                eventSubscribers = Objects.requireNonNullElse(this.subscribers.putIfAbsent(eventType, newSet), newSet);
            }
            eventSubscribers.addAll(eventMethodsInListener);
        }
    }

    void unregister(Object listener) {
        MultiValueMap<Class<?>, Subscriber> listenerMethods = this.findAllSubscribers(listener);
        for (Map.Entry entry : listenerMethods.entrySet()) {
            Class eventType = (Class)entry.getKey();
            Collection listenerMethodsForType = (Collection)entry.getValue();
            CopyOnWriteArraySet currentSubscribers = (CopyOnWriteArraySet)this.subscribers.get(eventType);
            if (currentSubscribers != null && currentSubscribers.removeAll(listenerMethodsForType)) continue;
            throw new IllegalArgumentException("missing event subscriber for an annotated method. Is " + listener + " registered?");
        }
    }

    @VisibleForTesting
    Set<Subscriber> getSubscribersForTesting(Class<?> eventType) {
        return Objects.requireNonNullElse((Set)this.subscribers.get(eventType), Collections.emptySet());
    }

    Iterator<Subscriber> getSubscribers(Object event) {
        Set<Class<?>> eventTypes = SubscriberRegistry.flattenHierarchy(event.getClass());
        ArrayList subscriberIterators = new ArrayList(eventTypes.size());
        for (Class<?> eventType : eventTypes) {
            CopyOnWriteArraySet eventSubscribers = (CopyOnWriteArraySet)this.subscribers.get(eventType);
            if (eventSubscribers == null) continue;
            subscriberIterators.add(eventSubscribers.iterator());
        }
        return Iterators.concat(subscriberIterators.iterator());
    }

    private MultiValueMap<Class<?>, Subscriber> findAllSubscribers(Object listener) {
        MultiValueHashMap methodsInListener = new MultiValueHashMap();
        Class<?> clazz = listener.getClass();
        for (Method method : subscriberMethodsCache.get(clazz)) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?> eventType = parameterTypes[0];
            methodsInListener.putElement(eventType, (Subscriber[])new Subscriber[]{Subscriber.create(this.bus, listener, method)});
        }
        return methodsInListener;
    }

    private static List<Method> getAnnotatedMethodsNotCached(Class<?> clazz) {
        Set<Class<?>> supertypes = TypeToken.getRawTypes(clazz);
        HashMap<MethodIdentifier, Method> identifiers = new HashMap<MethodIdentifier, Method>();
        for (Class<?> supertype : supertypes) {
            for (Method method : supertype.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Subscribe.class) || method.isSynthetic()) continue;
                Class<?>[] parameterTypes = method.getParameterTypes();
                Preconditions.checkArgument(parameterTypes.length == 1, "Method %s has @Subscribe annotation but has %s parameters. Subscriber methods must have exactly 1 parameter.", (Object)method, parameterTypes.length);
                Preconditions.checkArgument(!parameterTypes[0].isPrimitive(), "@Subscribe method %s's parameter is %s. Subscriber methods cannot accept primitives. Consider changing the parameter to %s.", (Object)method, (Object)parameterTypes[0].getName(), (Object)Primitives.wrap(parameterTypes[0]).getSimpleName());
                MethodIdentifier ident = new MethodIdentifier(method);
                if (identifiers.containsKey(ident)) continue;
                identifiers.put(ident, method);
            }
        }
        return List.copyOf(identifiers.values());
    }

    @VisibleForTesting
    static Set<Class<?>> flattenHierarchy(Class<?> concreteClass) {
        return flattenHierarchyCache.get(concreteClass);
    }

    private static final class MethodIdentifier {
        private final String name;
        private final List<Class<?>> parameterTypes;

        MethodIdentifier(Method method) {
            this.name = method.getName();
            this.parameterTypes = Arrays.asList(method.getParameterTypes());
        }

        public int hashCode() {
            return Objects.hash(this.name, this.parameterTypes);
        }

        public boolean equals(@CheckForNull Object o) {
            if (o instanceof MethodIdentifier) {
                MethodIdentifier ident = (MethodIdentifier)o;
                return this.name.equals(ident.name) && this.parameterTypes.equals(ident.parameterTypes);
            }
            return false;
        }
    }
}

