/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.eventbus;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.killbill.commons.eventbus.EventBus;
import org.killbill.commons.eventbus.SubscriberExceptionContext;
import org.killbill.commons.eventbus.SubscriberExceptionHandler;

class LoggingHandler
implements SubscriberExceptionHandler {
    static final SubscriberExceptionHandler INSTANCE = new LoggingHandler();

    LoggingHandler() {
    }

    private static Logger logger(SubscriberExceptionContext context) {
        return Logger.getLogger(EventBus.class.getName() + "." + context.getEventBus().identifier());
    }

    private static String message(SubscriberExceptionContext context) {
        Method method = context.getSubscriberMethod();
        return "Exception thrown by subscriber method " + method.getName() + "(" + method.getParameterTypes()[0].getName() + ") on subscriber " + context.getSubscriber() + " when dispatching event: " + context.getEvent();
    }

    @Override
    public void handleException(Throwable exception, SubscriberExceptionContext context) {
        Logger logger = LoggingHandler.logger(context);
        if (logger.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE, LoggingHandler.message(context), exception);
        }
    }
}

