/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.tag.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.ObjectType;
import org.killbill.billing.util.tag.Tag;

@JsonDeserialize(builder=Builder.class)
public class TagImp
implements Tag {
    protected DateTime createdDate;
    protected UUID id;
    protected UUID objectId;
    protected ObjectType objectType;
    protected UUID tagDefinitionId;
    protected DateTime updatedDate;

    public TagImp(TagImp that) {
        this.createdDate = that.createdDate;
        this.id = that.id;
        this.objectId = that.objectId;
        this.objectType = that.objectType;
        this.tagDefinitionId = that.tagDefinitionId;
        this.updatedDate = that.updatedDate;
    }

    protected TagImp(Builder<?> builder) {
        this.createdDate = builder.createdDate;
        this.id = builder.id;
        this.objectId = builder.objectId;
        this.objectType = builder.objectType;
        this.tagDefinitionId = builder.tagDefinitionId;
        this.updatedDate = builder.updatedDate;
    }

    protected TagImp() {
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getObjectId() {
        return this.objectId;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public UUID getTagDefinitionId() {
        return this.tagDefinitionId;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagImp that = (TagImp)o;
        if (this.createdDate != null ? 0 != this.createdDate.compareTo(that.createdDate) : that.createdDate != null) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.objectId, that.objectId)) {
            return false;
        }
        if (!Objects.equals(this.objectType, that.objectType)) {
            return false;
        }
        if (!Objects.equals(this.tagDefinitionId, that.tagDefinitionId)) {
            return false;
        }
        return !(this.updatedDate != null ? 0 != this.updatedDate.compareTo(that.updatedDate) : that.updatedDate != null);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.createdDate);
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.objectId);
        result = 31 * result + Objects.hashCode(this.objectType);
        result = 31 * result + Objects.hashCode(this.tagDefinitionId);
        result = 31 * result + Objects.hashCode(this.updatedDate);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("createdDate=").append(this.createdDate);
        sb.append(", ");
        sb.append("id=").append(this.id);
        sb.append(", ");
        sb.append("objectId=").append(this.objectId);
        sb.append(", ");
        sb.append("objectType=").append(this.objectType);
        sb.append(", ");
        sb.append("tagDefinitionId=").append(this.tagDefinitionId);
        sb.append(", ");
        sb.append("updatedDate=").append(this.updatedDate);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected DateTime createdDate;
        protected UUID id;
        protected UUID objectId;
        protected ObjectType objectType;
        protected UUID tagDefinitionId;
        protected DateTime updatedDate;

        public Builder() {
        }

        public Builder(Builder that) {
            this.createdDate = that.createdDate;
            this.id = that.id;
            this.objectId = that.objectId;
            this.objectType = that.objectType;
            this.tagDefinitionId = that.tagDefinitionId;
            this.updatedDate = that.updatedDate;
        }

        public T withCreatedDate(DateTime createdDate) {
            this.createdDate = createdDate;
            return (T)this;
        }

        public T withId(UUID id) {
            this.id = id;
            return (T)this;
        }

        public T withObjectId(UUID objectId) {
            this.objectId = objectId;
            return (T)this;
        }

        public T withObjectType(ObjectType objectType) {
            this.objectType = objectType;
            return (T)this;
        }

        public T withTagDefinitionId(UUID tagDefinitionId) {
            this.tagDefinitionId = tagDefinitionId;
            return (T)this;
        }

        public T withUpdatedDate(DateTime updatedDate) {
            this.updatedDate = updatedDate;
            return (T)this;
        }

        public T source(Tag that) {
            this.createdDate = that.getCreatedDate();
            this.id = that.getId();
            this.objectId = that.getObjectId();
            this.objectType = that.getObjectType();
            this.tagDefinitionId = that.getTagDefinitionId();
            this.updatedDate = that.getUpdatedDate();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public TagImp build() {
            return new TagImp(this.validate());
        }
    }
}

