/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.tag.boilerplate;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.ObjectType;
import org.killbill.billing.util.tag.TagDefinition;

@JsonDeserialize(builder=Builder.class)
public class TagDefinitionImp
implements TagDefinition {
    protected List<ObjectType> applicableObjectTypes;
    protected DateTime createdDate;
    protected String description;
    protected UUID id;
    protected Boolean isControlTag;
    protected String name;
    protected DateTime updatedDate;

    public TagDefinitionImp(TagDefinitionImp that) {
        this.applicableObjectTypes = that.applicableObjectTypes;
        this.createdDate = that.createdDate;
        this.description = that.description;
        this.id = that.id;
        this.isControlTag = that.isControlTag;
        this.name = that.name;
        this.updatedDate = that.updatedDate;
    }

    protected TagDefinitionImp(Builder<?> builder) {
        this.applicableObjectTypes = builder.applicableObjectTypes;
        this.createdDate = builder.createdDate;
        this.description = builder.description;
        this.id = builder.id;
        this.isControlTag = builder.isControlTag;
        this.name = builder.name;
        this.updatedDate = builder.updatedDate;
    }

    protected TagDefinitionImp() {
    }

    public List<ObjectType> getApplicableObjectTypes() {
        return this.applicableObjectTypes;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public String getDescription() {
        return this.description;
    }

    public UUID getId() {
        return this.id;
    }

    @JsonGetter(value="isControlTag")
    public Boolean isControlTag() {
        return this.isControlTag;
    }

    public String getName() {
        return this.name;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagDefinitionImp that = (TagDefinitionImp)o;
        if (!Objects.equals(this.applicableObjectTypes, that.applicableObjectTypes)) {
            return false;
        }
        if (this.createdDate != null ? 0 != this.createdDate.compareTo(that.createdDate) : that.createdDate != null) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.isControlTag, that.isControlTag)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return !(this.updatedDate != null ? 0 != this.updatedDate.compareTo(that.updatedDate) : that.updatedDate != null);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.applicableObjectTypes);
        result = 31 * result + Objects.hashCode(this.createdDate);
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.isControlTag);
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.updatedDate);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("applicableObjectTypes=").append(this.applicableObjectTypes);
        sb.append(", ");
        sb.append("createdDate=").append(this.createdDate);
        sb.append(", ");
        sb.append("description=");
        if (this.description == null) {
            sb.append(this.description);
        } else {
            sb.append("'").append(this.description).append("'");
        }
        sb.append(", ");
        sb.append("id=").append(this.id);
        sb.append(", ");
        sb.append("isControlTag=").append(this.isControlTag);
        sb.append(", ");
        sb.append("name=");
        if (this.name == null) {
            sb.append(this.name);
        } else {
            sb.append("'").append(this.name).append("'");
        }
        sb.append(", ");
        sb.append("updatedDate=").append(this.updatedDate);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected List<ObjectType> applicableObjectTypes;
        protected DateTime createdDate;
        protected String description;
        protected UUID id;
        protected Boolean isControlTag;
        protected String name;
        protected DateTime updatedDate;

        public Builder() {
        }

        public Builder(Builder that) {
            this.applicableObjectTypes = that.applicableObjectTypes;
            this.createdDate = that.createdDate;
            this.description = that.description;
            this.id = that.id;
            this.isControlTag = that.isControlTag;
            this.name = that.name;
            this.updatedDate = that.updatedDate;
        }

        public T withApplicableObjectTypes(List<ObjectType> applicableObjectTypes) {
            this.applicableObjectTypes = applicableObjectTypes;
            return (T)this;
        }

        public T withCreatedDate(DateTime createdDate) {
            this.createdDate = createdDate;
            return (T)this;
        }

        public T withDescription(String description) {
            this.description = description;
            return (T)this;
        }

        public T withId(UUID id) {
            this.id = id;
            return (T)this;
        }

        public T withIsControlTag(Boolean isControlTag) {
            this.isControlTag = isControlTag;
            return (T)this;
        }

        public T withName(String name) {
            this.name = name;
            return (T)this;
        }

        public T withUpdatedDate(DateTime updatedDate) {
            this.updatedDate = updatedDate;
            return (T)this;
        }

        public T source(TagDefinition that) {
            this.applicableObjectTypes = that.getApplicableObjectTypes();
            this.createdDate = that.getCreatedDate();
            this.description = that.getDescription();
            this.id = that.getId();
            this.isControlTag = that.isControlTag();
            this.name = that.getName();
            this.updatedDate = that.getUpdatedDate();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public TagDefinitionImp build() {
            return new TagDefinitionImp(this.validate());
        }
    }
}

