/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.usage.plugin.api.boilerplate.plugin;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.invoice.api.DryRunType;
import org.killbill.billing.usage.plugin.api.UsageContext;

@JsonDeserialize(builder=Builder.class)
public class UsageContextImp
implements UsageContext {
    protected UUID accountId;
    protected DryRunType dryRunType;
    protected LocalDate inputTargetDate;
    protected UUID tenantId;

    public UsageContextImp(UsageContextImp that) {
        this.accountId = that.accountId;
        this.dryRunType = that.dryRunType;
        this.inputTargetDate = that.inputTargetDate;
        this.tenantId = that.tenantId;
    }

    protected UsageContextImp(Builder<?> builder) {
        this.accountId = builder.accountId;
        this.dryRunType = builder.dryRunType;
        this.inputTargetDate = builder.inputTargetDate;
        this.tenantId = builder.tenantId;
    }

    protected UsageContextImp() {
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public DryRunType getDryRunType() {
        return this.dryRunType;
    }

    public LocalDate getInputTargetDate() {
        return this.inputTargetDate;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageContextImp that = (UsageContextImp)o;
        if (!Objects.equals(this.accountId, that.accountId)) {
            return false;
        }
        if (!Objects.equals(this.dryRunType, that.dryRunType)) {
            return false;
        }
        if (this.inputTargetDate != null ? 0 != this.inputTargetDate.compareTo(that.inputTargetDate) : that.inputTargetDate != null) {
            return false;
        }
        return Objects.equals(this.tenantId, that.tenantId);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.accountId);
        result = 31 * result + Objects.hashCode(this.dryRunType);
        result = 31 * result + Objects.hashCode(this.inputTargetDate);
        result = 31 * result + Objects.hashCode(this.tenantId);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("accountId=").append(this.accountId);
        sb.append(", ");
        sb.append("dryRunType=").append(this.dryRunType);
        sb.append(", ");
        sb.append("inputTargetDate=").append(this.inputTargetDate);
        sb.append(", ");
        sb.append("tenantId=").append(this.tenantId);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected UUID accountId;
        protected DryRunType dryRunType;
        protected LocalDate inputTargetDate;
        protected UUID tenantId;

        public Builder() {
        }

        public Builder(Builder that) {
            this.accountId = that.accountId;
            this.dryRunType = that.dryRunType;
            this.inputTargetDate = that.inputTargetDate;
            this.tenantId = that.tenantId;
        }

        public T withAccountId(UUID accountId) {
            this.accountId = accountId;
            return (T)this;
        }

        public T withDryRunType(DryRunType dryRunType) {
            this.dryRunType = dryRunType;
            return (T)this;
        }

        public T withInputTargetDate(LocalDate inputTargetDate) {
            this.inputTargetDate = inputTargetDate;
            return (T)this;
        }

        public T withTenantId(UUID tenantId) {
            this.tenantId = tenantId;
            return (T)this;
        }

        public T source(UsageContext that) {
            this.accountId = that.getAccountId();
            this.dryRunType = that.getDryRunType();
            this.inputTargetDate = that.getInputTargetDate();
            this.tenantId = that.getTenantId();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public UsageContextImp build() {
            return new UsageContextImp(this.validate());
        }
    }
}

