/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.joda.money.CurrencyUnit;
import org.joda.money.Money;
import org.killbill.billing.catalog.api.Currency;

public abstract class KillBillMoney {
    private KillBillMoney() {
    }

    public static BigDecimal of(BigDecimal amount, Currency currency) {
        CurrencyUnit currencyUnit = CurrencyUnit.of(currency.toString());
        return amount.setScale(currencyUnit.getDecimalPlaces(), 4);
    }

    public static long toMinorUnits(String currencyIsoCode, BigDecimal amountBD) {
        return KillBillMoney.toMinorUnits(currencyIsoCode, amountBD, RoundingMode.HALF_UP);
    }

    public static long toMinorUnits(String currencyIsoCode, BigDecimal amountBD, RoundingMode roundingMode) {
        CurrencyUnit currencyUnit = CurrencyUnit.of(currencyIsoCode);
        return Money.of(currencyUnit, amountBD, roundingMode).getAmountMinorLong();
    }

    public static BigDecimal fromMinorUnits(String currencyIsoCode, long amountBD) {
        CurrencyUnit currencyUnit = CurrencyUnit.of(currencyIsoCode);
        return Money.ofMinor(currencyUnit, amountBD).getAmount();
    }
}

