/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.core.resources;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.AsyncContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.jooby.Sse;

public class ServletSse
extends Sse {
    private final AtomicBoolean completed = new AtomicBoolean(false);
    private final ServletRequest req;
    private AsyncContext asyncContext;

    public ServletSse(ServletRequest req) {
        this.req = req;
    }

    @Override
    protected void closeInternal() {
        if (!this.completed.getAndSet(true)) {
            this.asyncContext.complete();
        }
    }

    @Override
    protected void handshake(Runnable handler) {
        this.asyncContext = this.req.getAsyncContext();
        this.asyncContext.setTimeout(0L);
        HttpServletResponse response = (HttpServletResponse)this.asyncContext.getResponse();
        response.setStatus(200);
        response.setContentType("text/event-stream");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Connection", "keep-alive");
        this.asyncContext.start(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompletableFuture<Optional<Object>> send(Optional<Object> id, byte[] data) {
        ServletSse servletSse = this;
        synchronized (servletSse) {
            CompletableFuture<Optional<Object>> promise = new CompletableFuture<Optional<Object>>();
            try {
                ServletResponse response = this.asyncContext.getResponse();
                response.getOutputStream().write(data);
                response.getOutputStream().flush();
                promise.complete(id);
            }
            catch (IOException e) {
                promise.completeExceptionally(e);
                this.ifClose(e.getCause() instanceof IOException ? e.getCause() : e);
            }
            return promise;
        }
    }
}

