/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api.payment;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.payment.plugin.api.boilerplate.HostedPaymentPageFormDescriptorImp;
import org.killbill.billing.plugin.util.http.QueryComputer;
import org.killbill.billing.plugin.util.http.URIUtils;

@JsonDeserialize(builder=Builder.class)
public class PluginHostedPaymentPageFormDescriptor
extends HostedPaymentPageFormDescriptorImp {
    public static final String GET = "GET";
    public static final String POST = "POST";

    public PluginHostedPaymentPageFormDescriptor(UUID kbAccountId, String formUrl) {
        this(kbAccountId, GET, formUrl, Collections.emptyList());
    }

    public PluginHostedPaymentPageFormDescriptor(UUID kbAccountId, String formUrl, List<PluginProperty> formFields) {
        this(kbAccountId, POST, formUrl, formFields);
    }

    public PluginHostedPaymentPageFormDescriptor(UUID kbAccountId, String formMethod, String formUrl, List<PluginProperty> formFields) {
        this(kbAccountId, formMethod, formUrl, formFields, Collections.emptyList());
    }

    public PluginHostedPaymentPageFormDescriptor(UUID kbAccountId, String formUrl, Map<String, String> queryParams) throws URISyntaxException {
        this(kbAccountId, GET, formUrl, queryParams);
    }

    public PluginHostedPaymentPageFormDescriptor(UUID kbAccountId, String formMethod, String formUrl, Map<String, String> queryParams) throws URISyntaxException {
        this(kbAccountId, formMethod, PluginHostedPaymentPageFormDescriptor.toFullUrl(formUrl, queryParams), Collections.emptyList(), Collections.emptyList());
    }

    public PluginHostedPaymentPageFormDescriptor(UUID kbAccountId, String formMethod, String formUrl, List<PluginProperty> formFields, List<PluginProperty> properties) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().withKbAccountId(kbAccountId)).withFormMethod(formMethod)).withFormUrl(formUrl)).withFormFields(formFields)).withProperties(properties)).validate());
    }

    protected PluginHostedPaymentPageFormDescriptor(Builder<?> builder) {
        super(builder);
    }

    public PluginHostedPaymentPageFormDescriptor(PluginHostedPaymentPageFormDescriptor that) {
        super(that);
    }

    private static String toFullUrl(String formUrl, Map<String, String> queryParams) throws URISyntaxException {
        URI rawUrl = new URI(formUrl);
        String fullQueryString = QueryComputer.URL_ENCODING_ENABLED_QUERY_COMPUTER.computeFullQueryString(rawUrl.getQuery(), queryParams);
        String fullUrl = URIUtils.buildURI(rawUrl.getScheme(), rawUrl.getUserInfo(), rawUrl.getHost(), rawUrl.getPort(), rawUrl.getAuthority(), rawUrl.getPath(), fullQueryString, rawUrl.getFragment());
        return fullUrl;
    }

    public static class Builder<T extends Builder<T>>
    extends HostedPaymentPageFormDescriptorImp.Builder<T> {
        public Builder() {
        }

        public Builder(Builder that) {
            super(that);
        }

        @Override
        public Builder validate() {
            return this;
        }

        @Override
        public PluginHostedPaymentPageFormDescriptor build() {
            return new PluginHostedPaymentPageFormDescriptor(this.validate());
        }
    }
}

