/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api.notification;

import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.Nullable;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillAPI;
import org.killbill.billing.plugin.api.notification.PluginConfigurationHandler;
import org.killbill.billing.plugin.api.notification.PluginTenantConfigurable;

public abstract class PluginTenantConfigurableConfigurationHandler<C>
extends PluginConfigurationHandler {
    private final Collection<UUID> configuredTenants = new HashSet<UUID>();
    private final PluginTenantConfigurable<C> pluginTenantConfigurable = new PluginTenantConfigurable();

    public PluginTenantConfigurableConfigurationHandler(String pluginName, OSGIKillbillAPI osgiKillbillAPI) {
        super(pluginName, osgiKillbillAPI);
    }

    protected abstract C createConfigurable(Properties var1);

    public void setDefaultConfigurable(C defaultConfigurable) {
        this.pluginTenantConfigurable.setDefaultConfigurable(defaultConfigurable);
    }

    @Override
    protected void configure(@Nullable UUID kbTenantId) {
        Object configurable = null;
        Properties properties = this.getTenantConfigurationAsProperties(kbTenantId);
        if (properties != null) {
            configurable = this.createConfigurable(properties);
        }
        this.pluginTenantConfigurable.put(kbTenantId, configurable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C getConfigurable(@Nullable UUID kbTenantId) {
        if (kbTenantId != null && !this.configuredTenants.contains(kbTenantId)) {
            Collection<UUID> collection = this.configuredTenants;
            synchronized (collection) {
                if (!this.configuredTenants.contains(kbTenantId)) {
                    this.configure(kbTenantId);
                    this.configuredTenants.add(kbTenantId);
                }
            }
        }
        return this.pluginTenantConfigurable.get(kbTenantId);
    }
}

