/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api.invoice;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoiceItemType;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillAPI;
import org.killbill.billing.plugin.api.invoice.PluginInvoiceItem;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.commons.utils.Preconditions;
import org.killbill.commons.utils.collect.MultiValueHashMap;

public abstract class PluginTaxCalculator {
    public static final List<InvoiceItemType> TAXABLE_ITEM_TYPES = List.of(InvoiceItemType.EXTERNAL_CHARGE, InvoiceItemType.FIXED, InvoiceItemType.RECURRING, InvoiceItemType.USAGE);
    public static final List<InvoiceItemType> ADJUSTMENT_ITEM_TYPES = List.of(InvoiceItemType.ITEM_ADJ, InvoiceItemType.REPAIR_ADJ);
    protected final OSGIKillbillAPI osgiKillbillAPI;

    public PluginTaxCalculator(OSGIKillbillAPI osgiKillbillAPI) {
        this.osgiKillbillAPI = osgiKillbillAPI;
    }

    public List<NewItemToTax> computeTaxItems(Invoice invoice, @Nullable Map<UUID, Set<UUID>> alreadyTaxedItemsWithAdjustments, TenantContext tenantContext) throws InvoiceApiException {
        HashMap<UUID, Invoice> invoicesCache = new HashMap<UUID, Invoice>();
        invoicesCache.put(invoice.getId(), invoice);
        HashMap<UUID, InvoiceItem> allItems = new HashMap<UUID, InvoiceItem>();
        HashMap<UUID, Object> allTaxableItems = new HashMap<UUID, Object>();
        MultiValueHashMap<UUID, UUID> adjustmentsByLinkedId = new MultiValueHashMap<UUID, UUID>();
        for (Object invoiceItem : invoice.getInvoiceItems()) {
            allItems.put(invoiceItem.getId(), (InvoiceItem)invoiceItem);
            if (this.isTaxableItem((InvoiceItem)invoiceItem)) {
                allTaxableItems.put(invoiceItem.getId(), invoiceItem);
                continue;
            }
            if (!this.isAdjustmentItem((InvoiceItem)invoiceItem)) continue;
            adjustmentsByLinkedId.putElement(invoiceItem.getLinkedItemId(), invoiceItem.getId());
        }
        HashSet<UUID> prevLinkedItemdIds = new HashSet<UUID>();
        for (UUID invoiceItemId : adjustmentsByLinkedId.keySet()) {
            if (allItems.get(invoiceItemId) != null) continue;
            Invoice previousInvoice = this.osgiKillbillAPI.getInvoiceUserApi().getInvoiceByInvoiceItem(invoiceItemId, tenantContext);
            invoicesCache.put(previousInvoice.getId(), previousInvoice);
            boolean foundIt = false;
            for (InvoiceItem previousInvoiceItem : previousInvoice.getInvoiceItems()) {
                if (!previousInvoiceItem.getId().equals(invoiceItemId)) continue;
                foundIt = true;
                if (!this.isTaxableItem(previousInvoiceItem)) break;
                allTaxableItems.put(previousInvoiceItem.getId(), previousInvoiceItem);
                break;
            }
            prevLinkedItemdIds.add(invoiceItemId);
            Preconditions.checkState(foundIt, "Couldn't find linked item %s", (Object)invoiceItemId);
        }
        LinkedList<NewItemToTax> newItemsToTax = new LinkedList<NewItemToTax>();
        for (Map.Entry entry : allTaxableItems.entrySet()) {
            UUID taxableItemId = (UUID)entry.getKey();
            InvoiceItem taxableItem = (InvoiceItem)entry.getValue();
            Set<UUID> adjustmentsAlreadyTakenIntoAccount = alreadyTaxedItemsWithAdjustments == null ? null : alreadyTaxedItemsWithAdjustments.get(taxableItemId);
            Collection currentAdjustmentIdsForTaxableId = Objects.requireNonNullElse((List)adjustmentsByLinkedId.get(taxableItemId), new LinkedList());
            if (adjustmentsAlreadyTakenIntoAccount != null) {
                currentAdjustmentIdsForTaxableId.removeAll(adjustmentsAlreadyTakenIntoAccount);
            }
            LinkedList<InvoiceItem> adjustments = currentAdjustmentIdsForTaxableId.isEmpty() ? null : new LinkedList<InvoiceItem>();
            for (UUID currentAdjustmentId : currentAdjustmentIdsForTaxableId) {
                adjustments.add((InvoiceItem)allItems.get(currentAdjustmentId));
            }
            if (adjustmentsAlreadyTakenIntoAccount != null) {
                if (currentAdjustmentIdsForTaxableId.isEmpty()) continue;
                newItemsToTax.add(new NewItemToTax((Invoice)invoicesCache.get(taxableItem.getInvoiceId()), taxableItem, adjustments, true));
                continue;
            }
            boolean returnOnly = prevLinkedItemdIds.contains(taxableItem.getId());
            newItemsToTax.add(new NewItemToTax((Invoice)invoicesCache.get(taxableItem.getInvoiceId()), taxableItem, adjustments, returnOnly));
        }
        return newItemsToTax;
    }

    protected InvoiceItem buildTaxItem(InvoiceItem originalItem, UUID invoiceId, @Nullable InvoiceItem adjustmentItem, BigDecimal amount, @Nullable String description) {
        if (amount == null || BigDecimal.ZERO.compareTo(amount) == 0) {
            return null;
        }
        if (adjustmentItem != null) {
            return PluginInvoiceItem.createTaxItem(originalItem, invoiceId, adjustmentItem.getStartDate(), adjustmentItem.getEndDate(), amount, Objects.requireNonNullElse(description, "Tax"));
        }
        return PluginInvoiceItem.createTaxItem(originalItem, invoiceId, amount, Objects.requireNonNullElse(description, "Tax"));
    }

    protected boolean isTaxableItem(InvoiceItem invoiceItem) {
        return invoiceItem.getAmount() != null && BigDecimal.ZERO.compareTo(invoiceItem.getAmount()) < 0 && TAXABLE_ITEM_TYPES.contains(invoiceItem.getInvoiceItemType());
    }

    protected boolean isTaxItem(InvoiceItem invoiceItem) {
        return InvoiceItemType.TAX.equals((Object)invoiceItem.getInvoiceItemType());
    }

    protected boolean isAdjustmentItem(InvoiceItem invoiceItem) {
        return ADJUSTMENT_ITEM_TYPES.contains(invoiceItem.getInvoiceItemType());
    }

    protected BigDecimal netAmount(InvoiceItem invoiceItem, @Nullable Iterable<InvoiceItem> adjustmentItems) {
        BigDecimal adjustedAmount = this.sum(adjustmentItems);
        return invoiceItem.getAmount() != null ? invoiceItem.getAmount().add(adjustedAmount) : adjustedAmount;
    }

    protected BigDecimal sum(@Nullable Iterable<InvoiceItem> invoiceItems) {
        BigDecimal sum = BigDecimal.ZERO;
        if (invoiceItems != null) {
            for (InvoiceItem invoiceItem : invoiceItems) {
                if (invoiceItem.getAmount() == null) continue;
                sum = sum.add(invoiceItem.getAmount());
            }
        }
        return sum;
    }

    public static class NewItemToTax {
        private final Invoice invoice;
        private final InvoiceItem taxableItem;
        private final List<InvoiceItem> adjustmentItems;
        private final boolean returnOnly;

        public NewItemToTax(Invoice invoice, InvoiceItem taxableItem, @Nullable List<InvoiceItem> adjustmentItems, boolean returnOnly) {
            Preconditions.checkNotNull(invoice, "invoice cannot be null");
            Preconditions.checkNotNull(taxableItem, "taxableItem cannot be null");
            Preconditions.checkState(adjustmentItems == null || !adjustmentItems.isEmpty(), "adjustmentItems shouldn't be empty by convention");
            Preconditions.checkState(!returnOnly || adjustmentItems != null, "adjustmentItems cannot be null if returnOnly");
            this.invoice = invoice;
            this.taxableItem = taxableItem;
            this.adjustmentItems = adjustmentItems;
            this.returnOnly = returnOnly;
        }

        public Invoice getInvoice() {
            return this.invoice;
        }

        public InvoiceItem getTaxableItem() {
            return this.taxableItem;
        }

        public List<InvoiceItem> getAdjustmentItems() {
            return this.adjustmentItems;
        }

        public boolean isReturnOnly() {
            return this.returnOnly;
        }

        public String toString() {
            return "NewItemToTax{invoice=" + this.invoice + ", taxableItem=" + this.taxableItem + ", adjustmentItems=" + this.adjustmentItems + ", returnOnly=" + this.returnOnly + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NewItemToTax that = (NewItemToTax)o;
            if (this.returnOnly != that.returnOnly) {
                return false;
            }
            if (this.invoice != null ? !this.invoice.equals(that.invoice) : that.invoice != null) {
                return false;
            }
            if (this.taxableItem != null ? !this.taxableItem.equals(that.taxableItem) : that.taxableItem != null) {
                return false;
            }
            return this.adjustmentItems != null ? this.adjustmentItems.equals(that.adjustmentItems) : that.adjustmentItems == null;
        }

        public int hashCode() {
            int result = this.invoice != null ? this.invoice.hashCode() : 0;
            result = 31 * result + (this.taxableItem != null ? this.taxableItem.hashCode() : 0);
            result = 31 * result + (this.adjustmentItems != null ? this.adjustmentItems.hashCode() : 0);
            result = 31 * result + (this.returnOnly ? 1 : 0);
            return result;
        }
    }
}

