/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api.invoice;

import java.util.Objects;
import org.joda.time.DateTime;
import org.killbill.billing.invoice.plugin.api.PriorInvoiceResult;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.plugin.api.invoice.PluginInvoiceResult;

public class PluginPriorInvoiceResult
extends PluginInvoiceResult
implements PriorInvoiceResult {
    private final boolean isAborted;
    private final DateTime rescheduleDate;

    public PluginPriorInvoiceResult() {
        this(false);
    }

    public PluginPriorInvoiceResult(boolean isAborted) {
        this(isAborted, null);
    }

    public PluginPriorInvoiceResult(DateTime rescheduleDate) {
        this(false, rescheduleDate);
    }

    public PluginPriorInvoiceResult(boolean isAborted, DateTime rescheduleDate) {
        this(isAborted, rescheduleDate, null);
    }

    public PluginPriorInvoiceResult(boolean isAborted, DateTime rescheduleDate, Iterable<PluginProperty> adjustedPluginProperties) {
        super(adjustedPluginProperties);
        this.isAborted = isAborted;
        this.rescheduleDate = rescheduleDate;
    }

    public boolean isAborted() {
        return this.isAborted;
    }

    public DateTime getRescheduleDate() {
        return this.rescheduleDate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PluginPriorInvoiceResult{");
        sb.append("isAborted=").append(this.isAborted);
        sb.append(", rescheduleDate=").append(this.rescheduleDate);
        sb.append(", adjustedPluginProperties=").append(this.adjustedPluginProperties);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginPriorInvoiceResult that = (PluginPriorInvoiceResult)o;
        if (this.isAborted != that.isAborted) {
            return false;
        }
        if (!Objects.equals(this.adjustedPluginProperties, that.adjustedPluginProperties)) {
            return false;
        }
        return this.rescheduleDate != null ? this.rescheduleDate.compareTo(that.rescheduleDate) == 0 : that.rescheduleDate == null;
    }

    public int hashCode() {
        int result = this.isAborted ? 1 : 0;
        result = 31 * result + (this.rescheduleDate != null ? this.rescheduleDate.hashCode() : 0);
        result = 31 * result + (this.adjustedPluginProperties != null ? this.adjustedPluginProperties.hashCode() : 0);
        return result;
    }
}

