/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.plugin.util.http.UTF8UrlDecoder;
import org.killbill.commons.utils.Strings;
import org.killbill.commons.utils.collect.Iterables;

public abstract class PluginProperties {
    @SafeVarargs
    public static Iterable<PluginProperty> merge(Iterable<PluginProperty> ... propertiesLists) {
        return PluginProperties.buildPluginProperties(PluginProperties.toMap(propertiesLists));
    }

    @SafeVarargs
    public static <K, V> Iterable<PluginProperty> merge(@Nullable Map<K, V> data, Iterable<PluginProperty> ... propertiesLists) {
        return PluginProperties.merge(PluginProperties.buildPluginProperties(data), PluginProperties.merge(propertiesLists));
    }

    @SafeVarargs
    public static Map<String, Object> toMap(Iterable<PluginProperty> ... propertiesLists) {
        HashMap<String, Object> mergedProperties = new HashMap<String, Object>();
        for (Iterable<PluginProperty> propertiesList : propertiesLists) {
            if (propertiesList == null) continue;
            for (PluginProperty pluginProperty : propertiesList) {
                if (pluginProperty.getKey() == null || pluginProperty.getValue() == null) continue;
                mergedProperties.put(pluginProperty.getKey(), pluginProperty.getValue());
            }
        }
        return mergedProperties;
    }

    @SafeVarargs
    public static Map<String, String> toStringMap(Iterable<PluginProperty> ... propertiesLists) {
        return PluginProperties.toMap(propertiesLists).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, (? super T entry) -> entry.getValue() == null ? null : entry.getValue().toString()));
    }

    public static String getValue(String pluginPropertyName, String fallbackValue, Iterable<PluginProperty> properties) {
        String pluginPropertyValue = PluginProperties.findPluginPropertyValue(pluginPropertyName, properties);
        return pluginPropertyValue == null ? fallbackValue : pluginPropertyValue;
    }

    public static String findPluginPropertyValue(String pluginPropertyName, @Nullable Iterable<PluginProperty> properties) {
        if (properties == null) {
            return null;
        }
        PluginProperty pluginProperty = Iterables.toStream(properties).filter(input -> input != null && pluginPropertyName.equals(input.getKey())).findFirst().orElse(null);
        if (pluginProperty == null || pluginProperty.getValue() == null) {
            return null;
        }
        String pluginPropertyString = String.valueOf(pluginProperty.getValue());
        return Strings.isNullOrEmpty(pluginPropertyString) ? null : pluginPropertyString;
    }

    public static String findAndDecodePluginPropertyValue(String pluginPropertyName, @Nullable Iterable<PluginProperty> properties) {
        String undecodedValue = PluginProperties.findPluginPropertyValue(pluginPropertyName, properties);
        return undecodedValue == null ? null : UTF8UrlDecoder.decode(undecodedValue).toString();
    }

    public static Iterable<PluginProperty> findPluginProperties(String key, @Nullable Iterable<PluginProperty> properties) {
        if (properties == null) {
            return null;
        }
        return Iterables.toStream(properties).filter(input -> key != null && input != null && key.equals(input.getKey())).collect(Collectors.toUnmodifiableSet());
    }

    public static Iterable<PluginProperty> findPluginProperties(Pattern keyPattern, @Nullable Iterable<PluginProperty> properties) {
        if (properties == null) {
            return null;
        }
        return Iterables.toStream(properties).filter(input -> keyPattern != null && input != null && keyPattern.matcher(input.getKey()).matches()).collect(Collectors.toUnmodifiableSet());
    }

    @SuppressFBWarnings(value={"WMI_WRONG_MAP_ITERATOR"})
    public static <K, V> List<PluginProperty> buildPluginProperties(@Nullable Map<K, V> data) {
        if (data == null || data.isEmpty()) {
            return Collections.emptyList();
        }
        return data.entrySet().stream().map(entry -> new PluginProperty(entry.getKey().toString(), entry.getValue(), Boolean.valueOf(false))).collect(Collectors.toUnmodifiableList());
    }
}

