/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.payment.plugin.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.payment.plugin.api.GatewayNotification;

@JsonDeserialize(builder=Builder.class)
public class GatewayNotificationImp
implements GatewayNotification {
    protected String entity;
    protected Map<String, List<String>> headers;
    protected UUID kbPaymentId;
    protected List<PluginProperty> properties;
    protected int status;

    public GatewayNotificationImp(GatewayNotificationImp that) {
        this.entity = that.entity;
        this.headers = that.headers;
        this.kbPaymentId = that.kbPaymentId;
        this.properties = that.properties;
        this.status = that.status;
    }

    protected GatewayNotificationImp(Builder<?> builder) {
        this.entity = builder.entity;
        this.headers = builder.headers;
        this.kbPaymentId = builder.kbPaymentId;
        this.properties = builder.properties;
        this.status = builder.status;
    }

    protected GatewayNotificationImp() {
    }

    public String getEntity() {
        return this.entity;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public UUID getKbPaymentId() {
        return this.kbPaymentId;
    }

    public List<PluginProperty> getProperties() {
        return this.properties;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GatewayNotificationImp that = (GatewayNotificationImp)o;
        if (!Objects.equals(this.entity, that.entity)) {
            return false;
        }
        if (!Objects.equals(this.headers, that.headers)) {
            return false;
        }
        if (!Objects.equals(this.kbPaymentId, that.kbPaymentId)) {
            return false;
        }
        if (!Objects.equals(this.properties, that.properties)) {
            return false;
        }
        return this.status == that.status;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.entity);
        result = 31 * result + Objects.hashCode(this.headers);
        result = 31 * result + Objects.hashCode(this.kbPaymentId);
        result = 31 * result + Objects.hashCode(this.properties);
        result = 31 * result + Objects.hashCode(this.status);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("entity=");
        if (this.entity == null) {
            sb.append(this.entity);
        } else {
            sb.append("'").append(this.entity).append("'");
        }
        sb.append(", ");
        sb.append("headers=").append(this.headers);
        sb.append(", ");
        sb.append("kbPaymentId=").append(this.kbPaymentId);
        sb.append(", ");
        sb.append("properties=").append(this.properties);
        sb.append(", ");
        sb.append("status=").append(this.status);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected String entity;
        protected Map<String, List<String>> headers;
        protected UUID kbPaymentId;
        protected List<PluginProperty> properties;
        protected int status;

        public Builder() {
        }

        public Builder(Builder that) {
            this.entity = that.entity;
            this.headers = that.headers;
            this.kbPaymentId = that.kbPaymentId;
            this.properties = that.properties;
            this.status = that.status;
        }

        public T withEntity(String entity) {
            this.entity = entity;
            return (T)this;
        }

        public T withHeaders(Map<String, List<String>> headers) {
            this.headers = headers;
            return (T)this;
        }

        public T withKbPaymentId(UUID kbPaymentId) {
            this.kbPaymentId = kbPaymentId;
            return (T)this;
        }

        public T withProperties(List<PluginProperty> properties) {
            this.properties = properties;
            return (T)this;
        }

        public T withStatus(int status) {
            this.status = status;
            return (T)this;
        }

        public T source(GatewayNotification that) {
            this.entity = that.getEntity();
            this.headers = that.getHeaders();
            this.kbPaymentId = that.getKbPaymentId();
            this.properties = that.getProperties();
            this.status = that.getStatus();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public GatewayNotificationImp build() {
            return new GatewayNotificationImp(this.validate());
        }
    }
}

