/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.payment.api.boilerplate;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Objects;
import org.killbill.billing.payment.api.PaymentOptions;

@JsonDeserialize(builder=Builder.class)
public class PaymentOptionsImp
implements PaymentOptions {
    protected boolean isExternalPayment;
    protected List<String> paymentControlPluginNames;

    public PaymentOptionsImp(PaymentOptionsImp that) {
        this.isExternalPayment = that.isExternalPayment;
        this.paymentControlPluginNames = that.paymentControlPluginNames;
    }

    protected PaymentOptionsImp(Builder<?> builder) {
        this.isExternalPayment = builder.isExternalPayment;
        this.paymentControlPluginNames = builder.paymentControlPluginNames;
    }

    protected PaymentOptionsImp() {
    }

    @JsonGetter(value="isExternalPayment")
    public boolean isExternalPayment() {
        return this.isExternalPayment;
    }

    public List<String> getPaymentControlPluginNames() {
        return this.paymentControlPluginNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentOptionsImp that = (PaymentOptionsImp)o;
        if (this.isExternalPayment != that.isExternalPayment) {
            return false;
        }
        return Objects.equals(this.paymentControlPluginNames, that.paymentControlPluginNames);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.isExternalPayment);
        result = 31 * result + Objects.hashCode(this.paymentControlPluginNames);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("isExternalPayment=").append(this.isExternalPayment);
        sb.append(", ");
        sb.append("paymentControlPluginNames=").append(this.paymentControlPluginNames);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected boolean isExternalPayment;
        protected List<String> paymentControlPluginNames;

        public Builder() {
        }

        public Builder(Builder that) {
            this.isExternalPayment = that.isExternalPayment;
            this.paymentControlPluginNames = that.paymentControlPluginNames;
        }

        public T withIsExternalPayment(boolean isExternalPayment) {
            this.isExternalPayment = isExternalPayment;
            return (T)this;
        }

        public T withPaymentControlPluginNames(List<String> paymentControlPluginNames) {
            this.paymentControlPluginNames = paymentControlPluginNames;
            return (T)this;
        }

        public T source(PaymentOptions that) {
            this.isExternalPayment = that.isExternalPayment();
            this.paymentControlPluginNames = that.getPaymentControlPluginNames();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public PaymentOptionsImp build() {
            return new PaymentOptionsImp(this.validate());
        }
    }
}

