/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.payment.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentMethod;
import org.killbill.billing.payment.api.PaymentMethodPlugin;
import org.killbill.billing.payment.api.PaymentOptions;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.audit.AuditLogWithHistory;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;

@JsonDeserialize(builder=Builder.class)
public class PaymentApiImp
implements PaymentApi {
    public PaymentApiImp(PaymentApiImp that) {
    }

    protected PaymentApiImp(Builder<?> builder) {
    }

    protected PaymentApiImp() {
    }

    public Pagination<Payment> getPayments(Long offset, Long limit, String pluginName, boolean withPluginInfo, boolean withAttempts, Iterable<PluginProperty> properties, TenantContext context) {
        throw new UnsupportedOperationException("getPayments(java.lang.Long, java.lang.Long, java.lang.String, boolean, boolean, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.TenantContext) must be implemented.");
    }

    public List<AuditLogWithHistory> getPaymentMethodAuditLogsWithHistoryForId(UUID paymentMethodId, AuditLevel auditLevel, TenantContext context) {
        throw new UnsupportedOperationException("getPaymentMethodAuditLogsWithHistoryForId(java.util.UUID, org.killbill.billing.util.api.AuditLevel, org.killbill.billing.util.callcontext.TenantContext) must be implemented.");
    }

    public Payment getPayment(UUID paymentId, boolean withPluginInfo, boolean withAttempts, Iterable<PluginProperty> properties, TenantContext context) {
        throw new UnsupportedOperationException("getPayment(java.util.UUID, boolean, boolean, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.TenantContext) must be implemented.");
    }

    public Payment createVoidWithPaymentControl(Account account, UUID paymentId, DateTime effectiveDate, String paymentTransactionExternalKey, Iterable<PluginProperty> properties, PaymentOptions paymentOptions, CallContext context) {
        throw new UnsupportedOperationException("createVoidWithPaymentControl(org.killbill.billing.account.api.Account, java.util.UUID, org.joda.time.DateTime, java.lang.String, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.payment.api.PaymentOptions, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Payment createChargeback(Account account, UUID paymentId, BigDecimal amount, Currency currency, DateTime effectiveDate, String paymentTransactionExternalKey, CallContext context) {
        throw new UnsupportedOperationException("createChargeback(org.killbill.billing.account.api.Account, java.util.UUID, java.math.BigDecimal, org.killbill.billing.catalog.api.Currency, org.joda.time.DateTime, java.lang.String, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public List<PaymentMethod> refreshPaymentMethods(Account account, String pluginName, Iterable<PluginProperty> properties, CallContext context) {
        throw new UnsupportedOperationException("refreshPaymentMethods(org.killbill.billing.account.api.Account, java.lang.String, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public UUID addPaymentMethodWithPaymentControl(Account account, String paymentMethodExternalKey, String pluginName, boolean setDefault, PaymentMethodPlugin paymentMethodInfo, Iterable<PluginProperty> properties, PaymentOptions paymentOptions, CallContext context) {
        throw new UnsupportedOperationException("addPaymentMethodWithPaymentControl(org.killbill.billing.account.api.Account, java.lang.String, java.lang.String, boolean, org.killbill.billing.payment.api.PaymentMethodPlugin, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.payment.api.PaymentOptions, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public List<AuditLogWithHistory> getPaymentAttemptAuditLogsWithHistoryForId(UUID paymentAttemptId, AuditLevel auditLevel, TenantContext context) {
        throw new UnsupportedOperationException("getPaymentAttemptAuditLogsWithHistoryForId(java.util.UUID, org.killbill.billing.util.api.AuditLevel, org.killbill.billing.util.callcontext.TenantContext) must be implemented.");
    }

    public Payment createCapture(Account account, UUID paymentId, BigDecimal amount, Currency currency, DateTime effectiveDate, String paymentTransactionExternalKey, Iterable<PluginProperty> properties, CallContext context) {
        throw new UnsupportedOperationException("createCapture(org.killbill.billing.account.api.Account, java.util.UUID, java.math.BigDecimal, org.killbill.billing.catalog.api.Currency, org.joda.time.DateTime, java.lang.String, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Payment getPaymentByExternalKey(String paymentExternalKey, boolean withPluginInfo, boolean withAttempts, Iterable<PluginProperty> properties, TenantContext context) {
        throw new UnsupportedOperationException("getPaymentByExternalKey(java.lang.String, boolean, boolean, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.TenantContext) must be implemented.");
    }

    public List<AuditLogWithHistory> getPaymentAuditLogsWithHistoryForId(UUID paymentId, AuditLevel auditLevel, TenantContext context) {
        throw new UnsupportedOperationException("getPaymentAuditLogsWithHistoryForId(java.util.UUID, org.killbill.billing.util.api.AuditLevel, org.killbill.billing.util.callcontext.TenantContext) must be implemented.");
    }

    public Payment createPurchase(Account account, UUID paymentMethodId, UUID paymentId, BigDecimal amount, Currency currency, DateTime effectiveDate, String paymentExternalKey, String paymentTransactionExternalKey, Iterable<PluginProperty> properties, CallContext context) {
        throw new UnsupportedOperationException("createPurchase(org.killbill.billing.account.api.Account, java.util.UUID, java.util.UUID, java.math.BigDecimal, org.killbill.billing.catalog.api.Currency, org.joda.time.DateTime, java.lang.String, java.lang.String, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public List<AuditLogWithHistory> getPaymentTransactionAuditLogsWithHistoryForId(UUID paymentTransactionId, AuditLevel auditLevel, TenantContext context) {
        throw new UnsupportedOperationException("getPaymentTransactionAuditLogsWithHistoryForId(java.util.UUID, org.killbill.billing.util.api.AuditLevel, org.killbill.billing.util.callcontext.TenantContext) must be implemented.");
    }

    public Payment notifyPendingTransactionOfStateChanged(Account account, UUID paymentTransactionId, boolean isSuccess, CallContext context) {
        throw new UnsupportedOperationException("notifyPendingTransactionOfStateChanged(org.killbill.billing.account.api.Account, java.util.UUID, boolean, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Pagination<Payment> searchPayments(String searchKey, Long offset, Long limit, boolean withPluginInfo, boolean withAttempts, Iterable<PluginProperty> properties, TenantContext context) {
        throw new UnsupportedOperationException("searchPayments(java.lang.String, java.lang.Long, java.lang.Long, boolean, boolean, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.TenantContext) must be implemented.");
    }

    public void cancelScheduledPaymentTransaction(UUID paymentTransactionId, CallContext context) {
        throw new UnsupportedOperationException("cancelScheduledPaymentTransaction(java.util.UUID, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Payment createRefundWithPaymentControl(Account account, UUID paymentId, BigDecimal amount, Currency currency, DateTime effectiveDate, String paymentTransactionExternalKey, Iterable<PluginProperty> properties, PaymentOptions paymentOptions, CallContext context) {
        throw new UnsupportedOperationException("createRefundWithPaymentControl(org.killbill.billing.account.api.Account, java.util.UUID, java.math.BigDecimal, org.killbill.billing.catalog.api.Currency, org.joda.time.DateTime, java.lang.String, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.payment.api.PaymentOptions, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Payment createCreditWithPaymentControl(Account account, UUID paymentMethodId, UUID paymentId, BigDecimal amount, Currency currency, DateTime effectiveDate, String paymentExternalKey, String paymentTransactionExternalKey, Iterable<PluginProperty> properties, PaymentOptions paymentOptions, CallContext context) {
        throw new UnsupportedOperationException("createCreditWithPaymentControl(org.killbill.billing.account.api.Account, java.util.UUID, java.util.UUID, java.math.BigDecimal, org.killbill.billing.catalog.api.Currency, org.joda.time.DateTime, java.lang.String, java.lang.String, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.payment.api.PaymentOptions, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Payment getPaymentByTransactionExternalKey(String transactionExternalKey, boolean withPluginInfo, boolean withAttempts, Iterable<PluginProperty> properties, TenantContext context) {
        throw new UnsupportedOperationException("getPaymentByTransactionExternalKey(java.lang.String, boolean, boolean, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.TenantContext) must be implemented.");
    }

    public List<PaymentMethod> refreshPaymentMethods(Account account, Iterable<PluginProperty> properties, CallContext context) {
        throw new UnsupportedOperationException("refreshPaymentMethods(org.killbill.billing.account.api.Account, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public PaymentMethod getPaymentMethodByExternalKey(String paymentMethodExternalKey, boolean includedInactive, boolean withPluginInfo, Iterable<PluginProperty> properties, TenantContext context) {
        throw new UnsupportedOperationException("getPaymentMethodByExternalKey(java.lang.String, boolean, boolean, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.TenantContext) must be implemented.");
    }

    public Pagination<PaymentMethod> searchPaymentMethods(String searchKey, Long offset, Long limit, String pluginName, boolean withPluginInfo, Iterable<PluginProperty> properties, TenantContext context) {
        throw new UnsupportedOperationException("searchPaymentMethods(java.lang.String, java.lang.Long, java.lang.Long, java.lang.String, boolean, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.TenantContext) must be implemented.");
    }

    public Payment createChargebackWithPaymentControl(Account account, UUID paymentId, BigDecimal amount, Currency currency, DateTime effectiveDate, String paymentTransactionExternalKey, PaymentOptions paymentOptions, CallContext context) {
        throw new UnsupportedOperationException("createChargebackWithPaymentControl(org.killbill.billing.account.api.Account, java.util.UUID, java.math.BigDecimal, org.killbill.billing.catalog.api.Currency, org.joda.time.DateTime, java.lang.String, org.killbill.billing.payment.api.PaymentOptions, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Pagination<PaymentMethod> getPaymentMethods(Long offset, Long limit, String pluginName, boolean withPluginInfo, Iterable<PluginProperty> properties, TenantContext context) {
        throw new UnsupportedOperationException("getPaymentMethods(java.lang.Long, java.lang.Long, java.lang.String, boolean, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.TenantContext) must be implemented.");
    }

    public UUID addPaymentMethod(Account account, String paymentMethodExternalKey, String pluginName, boolean setDefault, PaymentMethodPlugin paymentMethodInfo, Iterable<PluginProperty> properties, CallContext context) {
        throw new UnsupportedOperationException("addPaymentMethod(org.killbill.billing.account.api.Account, java.lang.String, java.lang.String, boolean, org.killbill.billing.payment.api.PaymentMethodPlugin, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Payment createCredit(Account account, UUID paymentMethodId, UUID paymentId, BigDecimal amount, Currency currency, DateTime effectiveDate, String paymentExternalKey, String paymentTransactionExternalKey, Iterable<PluginProperty> properties, CallContext context) {
        throw new UnsupportedOperationException("createCredit(org.killbill.billing.account.api.Account, java.util.UUID, java.util.UUID, java.math.BigDecimal, org.killbill.billing.catalog.api.Currency, org.joda.time.DateTime, java.lang.String, java.lang.String, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public void cancelScheduledPaymentTransaction(String paymentTransactionExternalKey, CallContext context) {
        throw new UnsupportedOperationException("cancelScheduledPaymentTransaction(java.lang.String, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public void setDefaultPaymentMethod(Account account, UUID paymentMethodId, Iterable<PluginProperty> properties, CallContext context) {
        throw new UnsupportedOperationException("setDefaultPaymentMethod(org.killbill.billing.account.api.Account, java.util.UUID, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Payment createAuthorization(Account account, UUID paymentMethodId, UUID paymentId, BigDecimal amount, Currency currency, DateTime effectiveDate, String paymentExternalKey, String paymentTransactionExternalKey, Iterable<PluginProperty> properties, CallContext context) {
        throw new UnsupportedOperationException("createAuthorization(org.killbill.billing.account.api.Account, java.util.UUID, java.util.UUID, java.math.BigDecimal, org.killbill.billing.catalog.api.Currency, org.joda.time.DateTime, java.lang.String, java.lang.String, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Pagination<PaymentMethod> getPaymentMethods(Long offset, Long limit, boolean withPluginInfo, Iterable<PluginProperty> properties, TenantContext context) {
        throw new UnsupportedOperationException("getPaymentMethods(java.lang.Long, java.lang.Long, boolean, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.TenantContext) must be implemented.");
    }

    public Payment createVoid(Account account, UUID paymentId, DateTime effectiveDate, String paymentTransactionExternalKey, Iterable<PluginProperty> properties, CallContext context) {
        throw new UnsupportedOperationException("createVoid(org.killbill.billing.account.api.Account, java.util.UUID, org.joda.time.DateTime, java.lang.String, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Pagination<PaymentMethod> searchPaymentMethods(String searchKey, Long offset, Long limit, boolean withPluginInfo, Iterable<PluginProperty> properties, TenantContext context) {
        throw new UnsupportedOperationException("searchPaymentMethods(java.lang.String, java.lang.Long, java.lang.Long, boolean, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.TenantContext) must be implemented.");
    }

    public void deletePaymentMethod(Account account, UUID paymentMethodId, boolean deleteDefaultPaymentMethodWithAutoPayOff, boolean forceDefaultPaymentMethodDeletion, Iterable<PluginProperty> properties, CallContext context) {
        throw new UnsupportedOperationException("deletePaymentMethod(org.killbill.billing.account.api.Account, java.util.UUID, boolean, boolean, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Payment getPaymentByTransactionId(UUID transactionId, boolean withPluginInfo, boolean withAttempts, Iterable<PluginProperty> properties, TenantContext context) {
        throw new UnsupportedOperationException("getPaymentByTransactionId(java.util.UUID, boolean, boolean, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.TenantContext) must be implemented.");
    }

    public Payment createAuthorizationWithPaymentControl(Account account, UUID paymentMethodId, UUID paymentId, BigDecimal amount, Currency currency, DateTime effectiveDate, String paymentExternalKey, String paymentTransactionExternalKey, Iterable<PluginProperty> properties, PaymentOptions paymentOptions, CallContext context) {
        throw new UnsupportedOperationException("createAuthorizationWithPaymentControl(org.killbill.billing.account.api.Account, java.util.UUID, java.util.UUID, java.math.BigDecimal, org.killbill.billing.catalog.api.Currency, org.joda.time.DateTime, java.lang.String, java.lang.String, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.payment.api.PaymentOptions, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public List<Payment> getAccountPayments(UUID accountId, boolean withPluginInfo, boolean withAttempts, Iterable<PluginProperty> properties, TenantContext context) {
        throw new UnsupportedOperationException("getAccountPayments(java.util.UUID, boolean, boolean, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.TenantContext) must be implemented.");
    }

    public Pagination<Payment> searchPayments(String searchKey, Long offset, Long limit, String pluginName, boolean withPluginInfo, boolean withAttempts, Iterable<PluginProperty> properties, TenantContext context) {
        throw new UnsupportedOperationException("searchPayments(java.lang.String, java.lang.Long, java.lang.Long, java.lang.String, boolean, boolean, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.TenantContext) must be implemented.");
    }

    public Payment createRefund(Account account, UUID paymentId, BigDecimal amount, Currency currency, DateTime effectiveDate, String paymentTransactionExternalKey, Iterable<PluginProperty> properties, CallContext context) {
        throw new UnsupportedOperationException("createRefund(org.killbill.billing.account.api.Account, java.util.UUID, java.math.BigDecimal, org.killbill.billing.catalog.api.Currency, org.joda.time.DateTime, java.lang.String, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public List<PaymentMethod> getAccountPaymentMethods(UUID accountId, boolean includedInactive, boolean withPluginInfo, Iterable<PluginProperty> properties, TenantContext context) {
        throw new UnsupportedOperationException("getAccountPaymentMethods(java.util.UUID, boolean, boolean, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.TenantContext) must be implemented.");
    }

    public Payment createChargebackReversal(Account account, UUID paymentId, DateTime effectiveDate, String paymentTransactionExternalKey, CallContext context) {
        throw new UnsupportedOperationException("createChargebackReversal(org.killbill.billing.account.api.Account, java.util.UUID, org.joda.time.DateTime, java.lang.String, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Payment notifyPendingTransactionOfStateChangedWithPaymentControl(Account account, UUID paymentTransactionId, boolean isSuccess, PaymentOptions paymentOptions, CallContext context) {
        throw new UnsupportedOperationException("notifyPendingTransactionOfStateChangedWithPaymentControl(org.killbill.billing.account.api.Account, java.util.UUID, boolean, org.killbill.billing.payment.api.PaymentOptions, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Pagination<Payment> getPayments(Long offset, Long limit, boolean withPluginInfo, boolean withAttempts, Iterable<PluginProperty> properties, TenantContext context) {
        throw new UnsupportedOperationException("getPayments(java.lang.Long, java.lang.Long, boolean, boolean, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.TenantContext) must be implemented.");
    }

    public Payment createChargebackReversalWithPaymentControl(Account account, UUID paymentId, DateTime effectiveDate, String paymentTransactionExternalKey, PaymentOptions paymentOptions, CallContext context) {
        throw new UnsupportedOperationException("createChargebackReversalWithPaymentControl(org.killbill.billing.account.api.Account, java.util.UUID, org.joda.time.DateTime, java.lang.String, org.killbill.billing.payment.api.PaymentOptions, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public Payment createCaptureWithPaymentControl(Account account, UUID paymentId, BigDecimal amount, Currency currency, DateTime effectiveDate, String paymentTransactionExternalKey, Iterable<PluginProperty> properties, PaymentOptions paymentOptions, CallContext context) {
        throw new UnsupportedOperationException("createCaptureWithPaymentControl(org.killbill.billing.account.api.Account, java.util.UUID, java.math.BigDecimal, org.killbill.billing.catalog.api.Currency, org.joda.time.DateTime, java.lang.String, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.payment.api.PaymentOptions, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public PaymentMethod getPaymentMethodById(UUID paymentMethodId, boolean includedInactive, boolean withPluginInfo, Iterable<PluginProperty> properties, TenantContext context) {
        throw new UnsupportedOperationException("getPaymentMethodById(java.util.UUID, boolean, boolean, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.util.callcontext.TenantContext) must be implemented.");
    }

    public Payment createPurchaseWithPaymentControl(Account account, UUID paymentMethodId, UUID paymentId, BigDecimal amount, Currency currency, DateTime effectiveDate, String paymentExternalKey, String paymentTransactionExternalKey, Iterable<PluginProperty> properties, PaymentOptions paymentOptions, CallContext context) {
        throw new UnsupportedOperationException("createPurchaseWithPaymentControl(org.killbill.billing.account.api.Account, java.util.UUID, java.util.UUID, java.math.BigDecimal, org.killbill.billing.catalog.api.Currency, org.joda.time.DateTime, java.lang.String, java.lang.String, java.lang.Iterable<org.killbill.billing.payment.api.PluginProperty>, org.killbill.billing.payment.api.PaymentOptions, org.killbill.billing.util.callcontext.CallContext) must be implemented.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        public Builder() {
        }

        public Builder(Builder that) {
        }

        public T source(PaymentApi that) {
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public PaymentApiImp build() {
            return new PaymentApiImp(this.validate());
        }
    }
}

