/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import java.util.Objects;
import org.joda.time.Period;
import org.killbill.billing.overdue.api.OverdueState;
import org.killbill.billing.overdue.api.OverdueStatesAccount;

@JsonDeserialize(builder=Builder.class)
public class OverdueStatesAccountImp
implements OverdueStatesAccount {
    protected Period initialReevaluationInterval;
    protected OverdueState[] states;

    public OverdueStatesAccountImp(OverdueStatesAccountImp that) {
        this.initialReevaluationInterval = that.initialReevaluationInterval;
        this.states = that.states;
    }

    protected OverdueStatesAccountImp(Builder<?> builder) {
        this.initialReevaluationInterval = builder.initialReevaluationInterval;
        this.states = builder.states;
    }

    protected OverdueStatesAccountImp() {
    }

    public Period getInitialReevaluationInterval() {
        return this.initialReevaluationInterval;
    }

    public OverdueState[] getStates() {
        return this.states;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverdueStatesAccountImp that = (OverdueStatesAccountImp)o;
        if (!Objects.equals(this.initialReevaluationInterval, that.initialReevaluationInterval)) {
            return false;
        }
        return Arrays.deepEquals(this.states, that.states);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.initialReevaluationInterval);
        result = 31 * result + Arrays.deepHashCode(this.states);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("initialReevaluationInterval=").append(this.initialReevaluationInterval);
        sb.append(", ");
        sb.append("states=").append(Arrays.toString(this.states));
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected Period initialReevaluationInterval;
        protected OverdueState[] states;

        public Builder() {
        }

        public Builder(Builder that) {
            this.initialReevaluationInterval = that.initialReevaluationInterval;
            this.states = that.states;
        }

        public T withInitialReevaluationInterval(Period initialReevaluationInterval) {
            this.initialReevaluationInterval = initialReevaluationInterval;
            return (T)this;
        }

        public T withStates(OverdueState[] states) {
            this.states = states;
            return (T)this;
        }

        public T source(OverdueStatesAccount that) {
            this.initialReevaluationInterval = that.getInitialReevaluationInterval();
            this.states = that.getStates();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public OverdueStatesAccountImp build() {
            return new OverdueStatesAccountImp(this.validate());
        }
    }
}

