/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.api.boilerplate;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.killbill.billing.catalog.api.Duration;
import org.killbill.billing.overdue.api.OverdueApiException;
import org.killbill.billing.overdue.api.OverdueCancellationPolicy;
import org.killbill.billing.overdue.api.OverdueCondition;
import org.killbill.billing.overdue.api.OverdueState;

@JsonDeserialize(builder=Builder.class)
public class OverdueStateImp
implements OverdueState {
    protected Duration autoReevaluationInterval;
    protected String externalMessage;
    protected boolean isBlockChanges;
    protected boolean isClearState;
    protected boolean isDisableEntitlementAndChangesBlocked;
    protected String name;
    protected OverdueCancellationPolicy overdueCancellationPolicy;
    protected OverdueCondition overdueCondition;

    public OverdueStateImp(OverdueStateImp that) {
        this.autoReevaluationInterval = that.autoReevaluationInterval;
        this.externalMessage = that.externalMessage;
        this.isBlockChanges = that.isBlockChanges;
        this.isClearState = that.isClearState;
        this.isDisableEntitlementAndChangesBlocked = that.isDisableEntitlementAndChangesBlocked;
        this.name = that.name;
        this.overdueCancellationPolicy = that.overdueCancellationPolicy;
        this.overdueCondition = that.overdueCondition;
    }

    protected OverdueStateImp(Builder<?> builder) {
        this.autoReevaluationInterval = builder.autoReevaluationInterval;
        this.externalMessage = builder.externalMessage;
        this.isBlockChanges = builder.isBlockChanges;
        this.isClearState = builder.isClearState;
        this.isDisableEntitlementAndChangesBlocked = builder.isDisableEntitlementAndChangesBlocked;
        this.name = builder.name;
        this.overdueCancellationPolicy = builder.overdueCancellationPolicy;
        this.overdueCondition = builder.overdueCondition;
    }

    protected OverdueStateImp() {
    }

    public Duration getAutoReevaluationInterval() {
        return this.autoReevaluationInterval;
    }

    public String getExternalMessage() {
        return this.externalMessage;
    }

    @JsonGetter(value="isBlockChanges")
    public boolean isBlockChanges() {
        return this.isBlockChanges;
    }

    @JsonGetter(value="isClearState")
    public boolean isClearState() {
        return this.isClearState;
    }

    @JsonGetter(value="isDisableEntitlementAndChangesBlocked")
    public boolean isDisableEntitlementAndChangesBlocked() {
        return this.isDisableEntitlementAndChangesBlocked;
    }

    public String getName() {
        return this.name;
    }

    public OverdueCancellationPolicy getOverdueCancellationPolicy() {
        return this.overdueCancellationPolicy;
    }

    public OverdueCondition getOverdueCondition() {
        return this.overdueCondition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverdueStateImp that = (OverdueStateImp)o;
        if (!Objects.equals(this.autoReevaluationInterval, that.autoReevaluationInterval)) {
            return false;
        }
        if (!Objects.equals(this.externalMessage, that.externalMessage)) {
            return false;
        }
        if (this.isBlockChanges != that.isBlockChanges) {
            return false;
        }
        if (this.isClearState != that.isClearState) {
            return false;
        }
        if (this.isDisableEntitlementAndChangesBlocked != that.isDisableEntitlementAndChangesBlocked) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.overdueCancellationPolicy, that.overdueCancellationPolicy)) {
            return false;
        }
        return Objects.equals(this.overdueCondition, that.overdueCondition);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.autoReevaluationInterval);
        result = 31 * result + Objects.hashCode(this.externalMessage);
        result = 31 * result + Objects.hashCode(this.isBlockChanges);
        result = 31 * result + Objects.hashCode(this.isClearState);
        result = 31 * result + Objects.hashCode(this.isDisableEntitlementAndChangesBlocked);
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.overdueCancellationPolicy);
        result = 31 * result + Objects.hashCode(this.overdueCondition);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("autoReevaluationInterval=").append(this.autoReevaluationInterval);
        sb.append(", ");
        sb.append("externalMessage=");
        if (this.externalMessage == null) {
            sb.append(this.externalMessage);
        } else {
            sb.append("'").append(this.externalMessage).append("'");
        }
        sb.append(", ");
        sb.append("isBlockChanges=").append(this.isBlockChanges);
        sb.append(", ");
        sb.append("isClearState=").append(this.isClearState);
        sb.append(", ");
        sb.append("isDisableEntitlementAndChangesBlocked=").append(this.isDisableEntitlementAndChangesBlocked);
        sb.append(", ");
        sb.append("name=");
        if (this.name == null) {
            sb.append(this.name);
        } else {
            sb.append("'").append(this.name).append("'");
        }
        sb.append(", ");
        sb.append("overdueCancellationPolicy=").append(this.overdueCancellationPolicy);
        sb.append(", ");
        sb.append("overdueCondition=").append(this.overdueCondition);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected Duration autoReevaluationInterval;
        protected String externalMessage;
        protected boolean isBlockChanges;
        protected boolean isClearState;
        protected boolean isDisableEntitlementAndChangesBlocked;
        protected String name;
        protected OverdueCancellationPolicy overdueCancellationPolicy;
        protected OverdueCondition overdueCondition;

        public Builder() {
        }

        public Builder(Builder that) {
            this.autoReevaluationInterval = that.autoReevaluationInterval;
            this.externalMessage = that.externalMessage;
            this.isBlockChanges = that.isBlockChanges;
            this.isClearState = that.isClearState;
            this.isDisableEntitlementAndChangesBlocked = that.isDisableEntitlementAndChangesBlocked;
            this.name = that.name;
            this.overdueCancellationPolicy = that.overdueCancellationPolicy;
            this.overdueCondition = that.overdueCondition;
        }

        public T withAutoReevaluationInterval(Duration autoReevaluationInterval) {
            this.autoReevaluationInterval = autoReevaluationInterval;
            return (T)this;
        }

        public T withExternalMessage(String externalMessage) {
            this.externalMessage = externalMessage;
            return (T)this;
        }

        public T withIsBlockChanges(boolean isBlockChanges) {
            this.isBlockChanges = isBlockChanges;
            return (T)this;
        }

        public T withIsClearState(boolean isClearState) {
            this.isClearState = isClearState;
            return (T)this;
        }

        public T withIsDisableEntitlementAndChangesBlocked(boolean isDisableEntitlementAndChangesBlocked) {
            this.isDisableEntitlementAndChangesBlocked = isDisableEntitlementAndChangesBlocked;
            return (T)this;
        }

        public T withName(String name) {
            this.name = name;
            return (T)this;
        }

        public T withOverdueCancellationPolicy(OverdueCancellationPolicy overdueCancellationPolicy) {
            this.overdueCancellationPolicy = overdueCancellationPolicy;
            return (T)this;
        }

        public T withOverdueCondition(OverdueCondition overdueCondition) {
            this.overdueCondition = overdueCondition;
            return (T)this;
        }

        public T source(OverdueState that) throws OverdueApiException {
            this.autoReevaluationInterval = that.getAutoReevaluationInterval();
            this.externalMessage = that.getExternalMessage();
            this.isBlockChanges = that.isBlockChanges();
            this.isClearState = that.isClearState();
            this.isDisableEntitlementAndChangesBlocked = that.isDisableEntitlementAndChangesBlocked();
            this.name = that.getName();
            this.overdueCancellationPolicy = that.getOverdueCancellationPolicy();
            this.overdueCondition = that.getOverdueCondition();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public OverdueStateImp build() {
            return new OverdueStateImp(this.validate());
        }
    }
}

