/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Set;
import org.killbill.commons.utils.collect.Iterables;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.inspector.TrustedTagInspector;

class YamlParser {
    private final Yaml yaml = YamlParser.createYaml();
    private final Path path;

    YamlParser(Path yamlFile) {
        this.path = yamlFile;
    }

    private static Yaml createYaml() {
        LoaderOptions options = new LoaderOptions();
        options.setTagInspector(new TrustedTagInspector());
        return new Yaml(options);
    }

    Set<Object> loadAll() {
        Set<Object> set;
        FileInputStream is = new FileInputStream(this.path.toFile());
        try {
            set = Iterables.toUnmodifiableSet(this.yaml.loadAll(is));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to parse yaml file: " + this.path.toAbsolutePath(), e);
            }
        }
        ((InputStream)is).close();
        return set;
    }
}

