/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class XmlParser {
    private final Logger logger = LoggerFactory.getLogger(XmlParser.class);
    private final JsonNode root;

    XmlParser(Path path) throws IOException {
        XmlMapper xmlMapper = new XmlMapper();
        this.root = xmlMapper.readTree(Files.readString(path));
    }

    String getValue(String xpath) {
        JsonNode xmlElement = this.root.at(xpath);
        if (xmlElement.isMissingNode()) {
            this.logger.warn("xmlElement.isMissingNode() return true and getValue() with {} xpath will return empty string", (Object)xmlElement);
            return "";
        }
        return xmlElement.textValue();
    }
}

