/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import org.killbill.billing.osgi.bundles.kpm.KpmProperties;
import org.killbill.billing.osgi.bundles.kpm.UriResolver;
import org.killbill.billing.osgi.bundles.kpm.impl.BasicUriResolver;
import org.killbill.billing.osgi.bundles.kpm.impl.NoneUriResolver;
import org.killbill.billing.osgi.bundles.kpm.impl.TokenUriResolver;

public class UrlResolverFactory {
    private final KpmProperties kpmProperties;

    public UrlResolverFactory(KpmProperties kpmProperties) {
        this.kpmProperties = kpmProperties;
    }

    private String getValidUrlIfSonatype(String url) {
        return url.contains("oss.sonatype.org") ? this.kpmProperties.getNexusUrl().concat("/content/repositories").concat(this.kpmProperties.getNexusRepository()) : url;
    }

    public UriResolver getVersionsProviderUrlResolver() {
        UriResolver.AuthenticationMethod authMethod = UriResolver.AuthenticationMethod.valueOf(this.kpmProperties.getNexusAuthMethod().toUpperCase());
        switch (authMethod) {
            case NONE: {
                String baseUrl = this.getValidUrlIfSonatype(this.kpmProperties.getNexusUrl() + this.kpmProperties.getNexusRepository());
                return new NoneUriResolver(baseUrl);
            }
            case BASIC: {
                String baseUrl = this.kpmProperties.getNexusUrl().concat(this.kpmProperties.getNexusRepository());
                String username = this.kpmProperties.getNexusAuthUsername();
                String password = this.kpmProperties.getNexusAuthPassword();
                return new BasicUriResolver(baseUrl, username, password);
            }
            case TOKEN: {
                String baseUrl = this.kpmProperties.getNexusUrl().concat(this.kpmProperties.getNexusRepository());
                return new TokenUriResolver(baseUrl, this.kpmProperties.getNexusAuthToken());
            }
        }
        throw new IllegalStateException("Unknown authentication method: " + this.kpmProperties.getNexusAuthMethod());
    }

    public UriResolver getPluginDirectoryUrlResolver() {
        KpmProperties.PluginsDirectory pluginsDirectory = this.kpmProperties.pluginsDirectory();
        UriResolver.AuthenticationMethod authMethod = UriResolver.AuthenticationMethod.valueOf(pluginsDirectory.getAuthMethod());
        switch (authMethod) {
            case NONE: {
                return new NoneUriResolver(this.getValidUrlIfSonatype(pluginsDirectory.getUrl()));
            }
            case BASIC: {
                return new BasicUriResolver(pluginsDirectory.getUrl(), pluginsDirectory.getAuthUsername(), pluginsDirectory.getAuthPassword());
            }
            case TOKEN: {
                return new TokenUriResolver(pluginsDirectory.getUrl(), pluginsDirectory.getAuthToken());
            }
        }
        throw new IllegalStateException("Unknown authentication method: " + pluginsDirectory.getAuthMethod());
    }

    public UriResolver getCoordinateBasedPluginDownloaderUrlResolver() {
        KpmProperties.PluginsInstall.Coordinate pluginsInstallCoordinate = this.kpmProperties.pluginsInstall().coordinate();
        UriResolver.AuthenticationMethod authMethod = UriResolver.AuthenticationMethod.valueOf(pluginsInstallCoordinate.getAuthMethod());
        switch (authMethod) {
            case NONE: {
                return new NoneUriResolver(this.getValidUrlIfSonatype(pluginsInstallCoordinate.getUrl()));
            }
            case BASIC: {
                return new BasicUriResolver(pluginsInstallCoordinate.getUrl(), pluginsInstallCoordinate.getAuthUsername(), pluginsInstallCoordinate.getAuthPassword());
            }
            case TOKEN: {
                return new TokenUriResolver(pluginsInstallCoordinate.getUrl(), pluginsInstallCoordinate.getAuthToken());
            }
        }
        throw new IllegalStateException("Unknown authentication method: " + pluginsInstallCoordinate.getAuthMethod());
    }
}

