/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.killbill.billing.osgi.bundles.kpm.KPMClient;
import org.killbill.billing.osgi.bundles.kpm.impl.FilesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Sha1Checker {
    private final Logger logger = LoggerFactory.getLogger(Sha1Checker.class);
    private final KPMClient httpClient;
    private final boolean shouldVerify;

    public Sha1Checker(KPMClient httpClient, boolean shouldVerify) {
        this.httpClient = httpClient;
        this.shouldVerify = shouldVerify;
    }

    boolean isDownloadedFileVerified(String sha1Url, Map<String, String> requestHeaders, Path downloadedPath) {
        boolean bl;
        if (!this.shouldVerify) {
            return true;
        }
        FileInputStream downloadedPathStream = new FileInputStream(downloadedPath.toFile());
        try {
            String downloadedPathSha1 = DigestUtils.sha1Hex(downloadedPathStream);
            String remoteSha1 = this.getOrLoadOriginalSha1(sha1Url, requestHeaders);
            this.logger.debug("downloadedPathSha1: {}, remoteSha1: {}", (Object)downloadedPathSha1, (Object)remoteSha1);
            bl = downloadedPathSha1.equals(remoteSha1);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)downloadedPathStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.logger.error("SHA1 verification will just return 'false' because it throws an IOException: ", (Throwable)e);
                return false;
            }
        }
        ((InputStream)downloadedPathStream).close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    private String getOrLoadOriginalSha1(String sha1Url, Map<String, String> requestHeader) {
        String string;
        Path result = null;
        try {
            result = this.httpClient.downloadToTempOS(sha1Url, requestHeader, "plugin", ".jar.sha1");
            string = Files.readString(result);
        }
        catch (Exception exception) {
            FilesUtils.deleteIfExists(result);
            catch (Throwable throwable) {
                FilesUtils.deleteIfExists(result);
                throw throwable;
            }
        }
        FilesUtils.deleteIfExists(result);
        return string;
        return "";
    }
}

