/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.killbill.commons.utils.Preconditions;
import org.killbill.commons.utils.Strings;

class PluginNamingResolver {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+[1-9]*).(\\d+).(\\d+)(?:-([a-zA-Z0-9]+))?");
    private final String pluginKey;
    private final String pluginVersion;
    private String stringContainsVersion;

    PluginNamingResolver(String pluginKey, String pluginVersion) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(pluginKey), "pluginKey is null or empty", new Object[0]);
        this.pluginKey = pluginKey;
        this.pluginVersion = pluginVersion;
    }

    static PluginNamingResolver of(String pluginKey) {
        return new PluginNamingResolver(pluginKey, null);
    }

    static PluginNamingResolver of(String pluginKey, String pluginVersion) {
        return new PluginNamingResolver(pluginKey, pluginVersion);
    }

    static PluginNamingResolver of(String pluginKey, String pluginVersion, String stringContainsVersion) {
        PluginNamingResolver result = PluginNamingResolver.of(pluginKey, pluginVersion);
        result.stringContainsVersion = stringContainsVersion;
        return result;
    }

    String getPluginName() {
        return this.pluginKey + "-plugin";
    }

    String getPluginVersion() {
        Preconditions.checkState(this.pluginVersion != null, "Cannot call #getPluginVersion() since PluginNamingResolver created without 'version'");
        String result = PluginNamingResolver.getVersionFromString(this.pluginVersion);
        if (Strings.isNullOrEmpty(result) && !Strings.isNullOrEmpty(this.stringContainsVersion)) {
            result = PluginNamingResolver.getVersionFromString(this.stringContainsVersion);
        }
        return Strings.isNullOrEmpty(result) ? "0.0.0" : result;
    }

    String getPluginJarFileName() {
        return this.getPluginName().concat("-").concat(this.getPluginVersion()).concat(".jar");
    }

    static String getVersionFromString(String string) {
        Matcher matcher = VERSION_PATTERN.matcher(string);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group(0).replaceAll("(?i)-{1,2}SNAPSHOT", "");
    }
}

